#!/bin/bash
#This script will install the drivers and utilities for 3DSP card.
#
PWD=$(pwd)
LOGFILE="${PWD}/logfile"

function PRINTSTDANDERROR {
  exec 1>&6
  exec 2>&7
}
function PRINTONLYERROR {
  exec 2>&7
  exec 1>>$LOGFILE
}
function PRINTONLYSTD {
  exec 1>&6
  exec 2>>$LOGFILE
}
function PRINTOFF {
  exec 2>>$LOGFILE
  exec 1>>$LOGFILE
}

exec 6>&1
exec 7>&2

OKFORMATPREFIX="\t\t\t\t\t[\033[32m"
FAILFORMATPREFIX="\t\t\t\t\t[\033[31m"
FORMATSUFFIX="\033[0m]"

PRINTOK="echo -e ${OKFORMATPREFIX} Ok ${FORMATSUFFIX}"
PRINTFAIL="echo -e ${FAILFORMATPREFIX}Fail${FORMATSUFFIX}"

FILESINDRIVERS=("3dspusbbus.ko" "3dspusbbtpriv.ko" "3dspusbbt.ko" "3dspusbwlanpriv.ko" "3dspusbwlan.ko")
FILESINWBTOOL=("btusbcfg.sh" "wbusb.conf" "3dspusbWB.desktop" "3dspusbWB.png" "uwb" "uwbtool")
FILESINAPPTOOLS=("blueman_1.10-3ubuntu1_i386.deb" "libpolkit2_0.9-4ubuntu1_i386.deb" "libpolkit-dbus2_0.9-4ubuntu1_i386.deb" "libpolkit-gnome0_0.9-1ubuntu3_i386.deb" "libpolkit-grant2_0.9-4ubuntu1_i386.deb" "policykit_0.9-4ubuntu1_i386.deb" "policykit-gnome_0.9-1ubuntu3_i386.deb" "tw.archive.ubuntu.com_ubuntu_dists_karmic_main_binary-i386_Packages"  "tw.archive.ubuntu.com_ubuntu_dists_karmic_multiverse_binary-i386_Packages" "tw.archive.ubuntu.com_ubuntu_dists_karmic_Release" "tw.archive.ubuntu.com_ubuntu_dists_karmic_Release.gpg" "tw.archive.ubuntu.com_ubuntu_dists_karmic_restricted_binary-i386_Packages" "tw.archive.ubuntu.com_ubuntu_dists_karmic_universe_binary-i386_Packages")

#This function will handle the error.
function handle_error()
{
    case "$1" in
      "NOTROOTUSER"     )
        echo -e "Notice: Permission denied. You MUST be root user."
        echo "Exit."
        exit 1;;
      "NOTSUPPORTKERNEL")
        echo -e "Notice: The kernel \"${CURRENTKERNEL}\" is NOT supported by this package."
        echo "Exit."
        exit 1;;
      "FILENOFOUND"     )
        echo -e "Error: Can not find $2."
        echo "Exit."
        exit 1;;
      "NEEDREBOOT"      )
        echo "Installation completed. Exit."
        echo "Startup 3DSP card throuth Applications->Accessories->3DSP uWB."
        echo "Thanks for using 3DSP card. Have a good day!"
        echo "You must restart your computer in order to use 3DSP card."
        exit 0;;
      *                 )
        echo -e "Error: Unknown error!"
        echo "Exit."
        exit 1;;
    esac
}

#This function will check the files needed.
function CheckFiles()
{
    echo -n " * Checking files..."
    [ -d drivers ] || { 
      ${PRINTFAIL}
      handle_error "FILENOFOUND" "directory drivers"
      }
    [ -d wbtool ] || { 
      ${PRINTFAIL}
      handle_error "FILENOFOUND" "directory wbtool"
      }
    [ -d apptools ] || { 
      ${PRINTFAIL}
      handle_error "FILENOFOUND" "directory apptools"
      }

    cd drivers
      [ -d ${CURRENTKERNEL} ] || { 
        ${PRINTFAIL}
        handle_error "FILENOFOUND" "directory drivers/${CURRENTKERNEL}"
      }
      cd ${CURRENTKERNEL} 
        for((i=0;i<${#FILESINDRIVERS[@]};i++))
        do
          [ -e ${FILESINDRIVERS[$i]} ] || {
             ${PRINTFAIL}
             handle_error "FILENOFOUND" "drivers/${CURRENTKERNEL}/${FILESINDRIVERS[$i]}"
          }
        done
      cd ..
    cd ..

    cd wbtool
    for((i=0;i<${#FILESINWBTOOL[@]};i++))
    do
      [ -e ${FILESINWBTOOL[$i]} ] || { 
        ${PRINTFAIL}
        handle_error "FILENOFOUND" "wbtool/${FILESINWBTOOL[$i]}"
      }
    done
    cd ..

    cd apptools
    for((i=0;i<${#FILESINAPPTOOLS[@]};i++))
    do
      [ -e ${FILESINAPPTOOLS[$i]} ] || { 
        ${PRINTFAIL}
        handle_error "FILENOFOUND" "apptools/${FILESINAPPTOOLS[$i]}"
      }
    done
    cd ..

}


#Checking user. MUST be root.
echo -n " * Checking user..."
[ "$(whoami)" = "root" ] || {
  ${PRINTFAIL}
  handle_error "NOTROOTUSER"
}
${PRINTOK}

#Verify kernel.
echo -n " * Verifying kernel..."
CURRENTKERNEL=`uname -r`

case "${CURRENTKERNEL}" in
    "2.6.31-14-generic" | "2.6.31-15-generic" | "2.6.31-16-generic" | "2.6.31-17-generic" | "2.6.31-18-generic" | "2.6.31-19-generic" | "2.6.31-20-generic")
      ${PRINTOK};;
    *                                        )
      ${PRINTFAIL}
      handle_error "NOTSUPPORTKERNEL";;
esac

#Check the files needed.
CheckFiles
${PRINTOK}

#Create logfile
#echo -n " * Creating logfile..."
: >$LOGFILE
#${PRINTOK}

#
PRINTONLYERROR
#
#Copy modules and utilities...
#echo -n " * Creating directories..."
TDSPDIR="/usr/local/3DSP/usb"
[ -d /usr/local/3DSP ] || mkdir /usr/local/3DSP
[ -d ${TDSPDIR} ] || mkdir ${TDSPDIR}
#${PRINTOK}

PRINTSTDANDERROR
echo -n " * Copying modules..."
PRINTONLYERROR

cp -f drivers/${CURRENTKERNEL}/3dspusbbus.ko  ${TDSPDIR}; chmod 644 ${TDSPDIR}/3dspusbbus.ko
cp -f drivers/${CURRENTKERNEL}/3dspusbbtpriv.ko   ${TDSPDIR}; chmod 644 ${TDSPDIR}/3dspusbbtpriv.ko
cp -f drivers/${CURRENTKERNEL}/3dspusbbt.ko ${TDSPDIR}; chmod 644 ${TDSPDIR}/3dspusbbt.ko
cp -f drivers/${CURRENTKERNEL}/3dspusbwlanpriv.ko ${TDSPDIR}; chmod 644 ${TDSPDIR}/3dspusbwlanpriv.ko
cp -f drivers/${CURRENTKERNEL}/3dspusbwlan.ko ${TDSPDIR}; chmod 644 ${TDSPDIR}/3dspusbwlan.ko

PRINTSTDANDERROR
${PRINTOK}
echo -n " * Installing utilities..."
PRINTONLYERROR

cd wbtool
    cp -f btusbcfg.sh     ${TDSPDIR}; chmod 444 ${TDSPDIR}/btusbcfg.sh
    cp -f wbusb.conf      ${TDSPDIR}; chmod 666 ${TDSPDIR}/wbusb.conf
    cp -f 3dspusbWB.desktop    /usr/share/applications/3dspusbWB.desktop
    cp -f 3dspusbWB.png        /usr/share/pixmaps/3dspusbWB.png
    cp -f 3dspusbWB.desktop    /etc/xdg/autostart/3dspusbWB.desktop
    cp -f uwb       /usr/bin/; chmod 755 /usr/bin/uwb
    cp -f uwbtool   /usr/bin/; chmod 755 /usr/bin/uwbtool
cd ..

PRINTSTDANDERROR
echo -e "\t\t\t\t[\033[32m Ok \033[0m]"

PRINTONLYERROR
#Install 3dsp-wifi-radar
cd apptools
  PRINTSTDANDERROR
  echo -n " * Installing 3dsp-wifi-radar..."
  PRINTONLYERROR
  tar zxvf 3dsp-wifi-radar.tar.gz
  cd 3dsp-wifi-radar
  PRINTOFF
  make -f /etc/wifi-radar/Makefile uninstall
  make install
  PRINTONLYERROR
  cp -f wifi-radar.desktop /usr/share/applications/
  cd ..
  rm -rf 3dsp-wifi-radar
  PRINTSTDANDERROR
  echo -e "\t\t\t[\033[32m Ok \033[0m]"
  PRINTONLYERROR
cd ..


PRINTONLYERROR
#Install Blueman-manager
[ -e /usr/bin/blueman-manager ] || {
    cd apptools
      PRINTSTDANDERROR
      echo " * Installing Blueman-manager..."
#      echo " Notice: The installation of Blueman-manager will take several minutes, please wait."
      cp -f tw.archive.ubuntu.com_ubuntu_dists_karmic_main_binary-i386_Packages /var/lib/apt/lists
      cp -f tw.archive.ubuntu.com_ubuntu_dists_karmic_multiverse_binary-i386_Packages       /var/lib/apt/lists
      cp -f tw.archive.ubuntu.com_ubuntu_dists_karmic_Release                   /var/lib/apt/lists
      cp -f tw.archive.ubuntu.com_ubuntu_dists_karmic_Release.gpg               /var/lib/apt/lists
      cp -f tw.archive.ubuntu.com_ubuntu_dists_karmic_restricted_binary-i386_Packages /var/lib/apt/lists
      cp -f tw.archive.ubuntu.com_ubuntu_dists_karmic_universe_binary-i386_Packages /var/lib/apt/lists
      cp -f blueman_1.10-3ubuntu1_i386.deb /var/cache/apt/archives
      cp -f libpolkit2_0.9-4ubuntu1_i386.deb /var/cache/apt/archives
      cp -f libpolkit-dbus2_0.9-4ubuntu1_i386.deb /var/cache/apt/archives
      cp -f libpolkit-gnome0_0.9-1ubuntu3_i386.deb /var/cache/apt/archives
      cp -f libpolkit-grant2_0.9-4ubuntu1_i386.deb /var/cache/apt/archives
      cp -f policykit_0.9-4ubuntu1_i386.deb /var/cache/apt/archives
      cp -f policykit-gnome_0.9-1ubuntu3_i386.deb /var/cache/apt/archives
      cp -f /etc/apt/sources.list /etc/apt/sources.list.3DSP.USB.main.tw.forubuntu.temp
      cp -f sources.list /etc/apt/
      if aptitude -y install blueman
      then
        echo -e "\t\t\t\t\t\t\t[\033[32m Ok \033[0m]"
      else
        echo -e "\t\t\t\t\t\t\t[\033[31mFail\033[0m]"
        echo -e "Installing \"Blueman-manager\" failed.You can install it later by typing:\napt-get install blueman"
      fi
      mv -f /etc/apt/sources.list.3DSP.USB.main.tw.forubuntu.temp /etc/apt/sources.list
    cd ..
}

PRINTSTDANDERROR
#Create /etc/init.d/tdspusbdriver and ln for auto-startup
echo -n " * Creating init script..."
PRINTONLYERROR

cp -f apptools/tdspusbcardinit /etc/init.d
chmod 744 /etc/init.d/tdspusbcardinit
update-rc.d tdspusbcardinit start 98 2 3 4 5 . stop 89 0 1 6 .

PRINTSTDANDERROR
echo -e "\t\t\t\t[\033[32m Ok \033[0m]"




#####################################################################3

PRINTOFF
#Remove old modules
sudo killall -q uwbtool uwb
[ -e /usr/bin/uwbtool ] && {
    uwbtool -r; sleep 1
}

CONT1=`lsmod | awk '$1=="3dspusbbt"{print $1}' | wc -l`
[ ${CONT1} -eq 0 ] || rmmod -f 3dspusbbt

CONT2=`lsmod | awk '$1=="3dspusbbtpriv"{print $1}' | wc -l`
[ ${CONT2} -eq 0 ] || rmmod -f 3dspusbbtpriv

CONT3=`lsmod | awk '$1=="3dspusbwlan"{print $1}' | wc -l`
[ ${CONT3} -eq 0 ] || rmmod -f 3dspusbwlan

CONT4=`lsmod | awk '$1=="3dspusbwlanpriv"{print $1}' | wc -l`
[ ${CONT4} -eq 0 ] || rmmod -f 3dspusbwlanpriv

CONT5=`lsmod | awk '$1=="3dspusbbus"{print $1}' | wc -l`
[ ${CONT5} -eq 0 ] || rmmod -f 3dspusbbus

PRINTONLYSTD
#Inserting modules
CONT5=`lsmod | awk '$1=="3dspusbbus"{print $1}' | wc -l`
[ ${CONT5} -eq 0 ] || handle_error "NEEDREBOOT"
PRINTOFF
insmod ${TDSPDIR}/3dspusbbus.ko

PRINTONLYSTD
CONT4=`lsmod | awk '$1=="3dspusbwlanpriv"{print $1}' | wc -l`
[ ${CONT4} -eq 0 ] || handle_error "NEEDREBOOT"
PRINTOFF
insmod ${TDSPDIR}/3dspusbwlanpriv.ko

PRINTONLYSTD
CONT3=`lsmod | awk '$1=="3dspusbwlan"{print $1}' | wc -l`
[ ${CONT3} -eq 0 ] || handle_error "NEEDREBOOT"
PRINTOFF
insmod ${TDSPDIR}/3dspusbwlan.ko


PRINTONLYSTD
CONT2=`lsmod | awk '$1=="3dspusbbtpriv"{print $1}' | wc -l`
[ ${CONT2} -eq 0 ] || handle_error "NEEDREBOOT"
PRINTOFF
insmod ${TDSPDIR}/3dspusbbtpriv.ko

PRINTONLYSTD
CONT1=`lsmod | awk '$1=="3dspusbbt"{print $1}' | wc -l`
[ ${CONT1} -eq 0 ] || handle_error "NEEDREBOOT"
PRINTOFF
insmod ${TDSPDIR}/3dspusbbt.ko

sleep 1
mknod  /dev/tdspusbbus c `cat /proc/devices | awk '$2=="3dspusbbus" {print $1}'` 0
PRINTONLYSTD
echo "Installation completed. Startup 3DSP card through Applications->Accessories->3DSP uWB."
echo "Thanks for using 3DSP card. Have a good day!"
exit 0

