#!/bin/bash
#This script will REMOVE the drivers and utilities for 3DSP card.
#
PWD=$(pwd)
LOGFILE="${PWD}/logfile"

function PRINTSTDANDERROR {
  exec 1>&6
  exec 2>&7
}
function PRINTONLYERROR {
  exec 2>&7
  exec 1>>$LOGFILE
}
function PRINTONLYSTD {
  exec 1>&6
  exec 2>>$LOGFILE
}
function PRINTOFF {
  exec 2>>$LOGFILE
  exec 1>>$LOGFILE
}

exec 6>&1
exec 7>&2

OKFORMATPREFIX="\t\t\t\t\t[\033[32m"
FAILFORMATPREFIX="\t\t\t\t\t[\033[31m"
FORMATSUFFIX="\033[0m]"

PRINTOK="echo -e ${OKFORMATPREFIX} Ok ${FORMATSUFFIX}"
PRINTFAIL="echo -e ${FAILFORMATPREFIX}Fail${FORMATSUFFIX}"

#This function will rmmod modules
function removemodule ()
{
    rmmod -f $1 || {
      PRINTONLYSTD
      ${PRINTOK}
      echo "Uinstallation completed. Exit."
      echo "Thanks for using 3DSP card. Have a good day!"
      echo "You need to restart your computer in order to UNLOAD the modules for 3DSP card."
      exit 0
    }
}


#Checking user. MUST be root.
echo -n " * Checking user..."
[ "$(whoami)" = "root" ] || {
        ${PRINTFAIL}
        echo "Notice: Permission denied. You MUST be root user."
        echo "Exit."
        exit 1
}
${PRINTOK}
echo -n "Remove the drivers and utilities for 3DSP card?(y/n) "
read answer
case "$answer" in
    "y" | "Y")
     ;;
    *  )
     echo "Exit."
     exit 0;;
esac

#Remove /etc/init.d/tdspusbdriver and ln for auto-startup
echo -n " * Removing init script..."
PRINTONLYERROR
update-rc.d -f tdspusbcardinit remove 0 1 2 3 4 5 6 .
rm -f /etc/init.d/tdspusbcardinit
PRINTSTDANDERROR
echo -e "\t\t\t\t[\033[32m Ok \033[0m]"

#"Remove utilites" MUST be before "Remove modules.
#Remove 3dsp-wifi-radar
echo -n " * Removing 3dsp-wifi-radar..."
killall -q 3dsp-wifi-radar; sleep 1
PRINTOFF
[ -d /usr/local/3DSP/pci ] || {
	make -f /etc/wifi-radar/Makefile uninstall
	rm  -rf /etc/wifi-radar
}
PRINTSTDANDERROR
echo -e "\t\t\t\t[\033[32m Ok \033[0m]"

#Remove utilities
echo -n " * Removing utilities..."
killall -q uwbtool uwb
PRINTOFF
uwbtool -r; sleep 1
PRINTONLYERROR
rm -f /usr/share/applications/3dspusbWB.desktop
rm -f /usr/share/pixmaps/3dspusbWB.png
rm -f /etc/xdg/autostart/3dspusbWB.desktop
rm -f /usr/bin/uwb
rm -f /usr/bin/uwbtool
PRINTSTDANDERROR
echo -e "\t\t\t\t[\033[32m Ok \033[0m]"

#Remove modules
echo -n " * Removing modules..."
PRINTONLYERROR
if [ -d /usr/local/3DSP/pci ];then
  rm -rf /usr/local/3DSP/usb
else
  rm -rf /usr/local/3DSP
fi
PRINTSTDANDERROR
${PRINTOK}

#Remove the file for Power Function
[ -e /etc/pm/sleep.d/33-3dsp-sleep.sh ] && rm -f /etc/pm/sleep.d/33-3dsp-sleep.sh

rm -f /dev/tdspusbbus

#Unload modules for 3DSP card.
echo -n " * Unload modules..."
PRINTOFF
CONT5=`lsmod | awk '$1=="3dspusbbt"{print $1}' | wc -l`
[ ${CONT5} -eq 0 ] || removemodule "3dspusbbt"

CONT4=`lsmod | awk '$1=="3dspusbbtpriv"{print $1}' | wc -l`
[ ${CONT4} -eq 0 ] || removemodule "3dspusbbtpriv"

CONT3=`lsmod | awk '$1=="3dspusbwlan"{print $1}' | wc -l`
[ ${CONT3} -eq 0 ] || removemodule "3dspusbwlan"

CONT2=`lsmod | awk '$1=="3dspusbwlanpriv"{print $1}' | wc -l`
[ ${CONT2} -eq 0 ] || removemodule "3dspusbwlanpriv"

CONT1=`lsmod | awk '$1=="3dspusbbus"{print $1}' | wc -l`
[ ${CONT1} -eq 0 ] || removemodule "3dspusbbus"
PRINTSTDANDERROR
${PRINTOK}
echo "Uninstallation completed. Exit."
echo "Thanks for using 3DSP card. Have a good day!"
exit 0
