	;
	; Ituner power sequencer for ITATX.3B
	;
	; pd 050404 turn the AMP off whenever the psu turns off 
	; pd 050324	fixed the AMP=off before turning the computer off in HARDOFF
	; pd 050321 added SureStop (the power-on signal isn't send. just power-off if needed)
	; pd 050318 wait 5 seconds before starting the computer in OFFDELAY ignition-off / ignition-on test
	; pd 050316 added a new configuration : 1h OFFDELAY / 1h15min HARDOFF
	; pd 050316	added a power-on check in the OFFDELAY when IGNITION comes back on
	; pd 050311	fixed HARDOFF=never shutting down
	; pd 050311 added 2 new settings.
	; pd 050309 wait for DEBOUNCE when IGNITION comes 'on' during HARDOFF period
	; pd 050309 fixed returning from STANDBY
	; pd 050210	faster led blinking when in deep discharge
	; pd 041010 change pinout for ITATX.3B
	;           change threshold voltage to 11V
	; pd 040725 change VIN/VSW12 pinout
	; pd 040521 initial code
	
	LIST	p=PIC16F819 	;Target processor
	#include "P16F819.INC"	;Header file for target processor
	
	; RA0 = VIN     analog in	12V not switched, 10K/3.3K divider
	; RA1 = VSW12   analog in	ignition 12V, 10K/3.3K divider
	; RA2 = PGOOD1  input	1 = 5V power good
	; RA3 = V3      analog in	3.3V for power good detection
	; RA4 = ON#     output	0 = enable power supply output
	; RA5 = PSON#   input	0 = enable power supply (from
	;		system board)
	; RA6 = ON      output	1 = enable power supply output
	; RA7 = SS1     output o.d.	0 = disable standby 5V
	
	; RB0 = DIP0    input, p.u.	mode configuration
	; RB1 = DIP1    input, p.u.	mode configuration
	; RB2 = DIP2    input, p.u.	mode configuration
	; RB3 = DIP3    input, p.u.	mode configuration
	; RB4 = AMPON   output	1 = audio amplifier on
	; RB5 = LED#    output o.d.	0 = turn on LED
	; RB6 = PSW#    output o.d.   0 = power switch pressed
	; RB7 = PWRGD   output o.d.   0 = power bad
	
	; Equates

GPA_OFF	equ	b'00010000'	;all off
GPA_ON	equ	b'01000000'	;all on
VSW12	equ	.141	;low battery threshold voltage
			;.141 = 11V
			;.128 = 10V
			;.115 = 9V
			;.102 = 8V
			;VSW12 / 4 / 5.0 * 256

ONDELAY	equ	.20	;power on delay 4 seconds
ONDELAY2	equ	.5	;wait 1 second until push button
BUTTON	equ	.1	;push button for 400 ms
HARDOFF	equ	.225	;hard off after 45 seconds
HEARTBEAT	equ	.256-.1	;1 ms per tick
HRTCNT	equ	.200	;200 timer ticks per time unit
PSON	equ	.20	;debounce power supply on (polls)
PSOFF	equ	.5	;debounce power supply off (polls)
PGON	equ	.200	;power good delay (ms)
PGOFF	equ	.3	;power bad delay (polls)
LOWOFF	equ	.301	;low battery delay
LEDCNTNORMAL	equ	.16	; LED counter for hard off flash 16
LEDCNTLOW		equ .1 ; LED counter for low battery threshold voltage
AMPDLY	equ	.26	;amplifier delay 5 seconds
NNV1	equ .0	;low counter for not_never
NNV2	equ .0	;high counter for not_never
SURESTOP	equ	.11	; switch settings for SureStop

	; Register variables
	;
	; (start at 0x70 to allow access regardless of bank)

tri_a	equ	0x70	;tristate shadow A
tri_b	equ	0x71	;tristate shadow B
cntr1l	equ	0x72	;state counter
cntr1h	equ	0x73	
cntr2l	equ	0x74	;state counter 2
cntr2h	equ	0x75
cntr3l	equ	0x76	;state counter 3
cntr3h	equ	0x77
psonctr	equ	0x78	;PS on debounce
psoffctr	equ	0x79	;PS off debounce
hrt	equ	0x7a	;heart rate counter
pgctr	equ	0x7b	;power good counter
pbad	equ	0x7c	;power bad counter
switch	equ	0x7d	;switch setting
ledctr	equ	0x7e	;LED flash counter
ampctr	equ	0x7f	;amplifier delay counter
ledcounter	equ	0x80	;value for the LED counter
check_never	equ	0x69	;flag for never power off selection
ignition_was_off equ 0x6a	; flag set if the ignition was turned off and is turned on during OFFDELAY
keep_amp_off	equ	0x6b	; flag for keeping the AMP off during HARDOFF

;-------- reset entry ---------------------------------------------------------

	org	0

	goto	reset
	
;-------- interrupt entry -----------------------------------------------------
	
	org	4
	retfie
	
;-------- set tristate registers (shadow register for easier change) ----------
	
set_tris	movf	tri_a,w
	banksel	TRISA
	movwf	TRISA
	movf	tri_b,w
	movwf	TRISB
	banksel	0	;return to bank 0
	return

;--------	synchronize to 200 ms timer heartbeat -------------------------------

	; if the code runs too long, we might miss some ticks -
	; no big deal...

delay200	clrwdt
	movlw	HRTCNT	;set 200 ticks
	movwf	hrt
delay2	btfss	PIR1,0	;did the timer overflow ?
	  goto	delay2	;:no
	movlw	HEARTBEAT	;reset the timer
	movwf	TMR1H
	bcf	PIR1,0	;clear the timer flag
	decfsz	hrt,f	;another poll ?
 	  goto	delay2
 	return

;-------- LED on --------------------------------------------------------------
	
led_on	bcf	tri_b,5	;enable output (o.d.)
	goto	set_tris
	
;-------- toggle LED ----------------------------------------------------------

led_inv	movlw	.32
	xorwf	tri_b,f
	goto	set_tris

;-------- full off (all converters off) ---------------------------------------
	
fulloff	movlw	GPA_OFF	;PORTA p39: off state
	movwf	PORTA
	bcf	tri_a,7	;SS1 low -> shut down 5V
	bcf	tri_b,7	;POWERGD low

;         LED off
	
led_off	bsf	tri_b,5	;disable output (o.d.)
	goto	set_tris

;-------- half on: 3.3V off, 5V on --------------------------------------------
	
halfon	movlw	GPA_OFF	;PORTA p39: off state
	movwf	PORTA
	bsf	tri_b,5	;led_off
halfon2	movlw	AMPDLY	;start amplifier counter
	movwf	ampctr
	bsf	tri_a,7	;SS1 hi-Z -> enable 5V
	bcf	tri_b,7	;POWERGD low
	goto	set_tris

;--------	full on: 3.3V on, 5V on ---------------------------------------------

fullon	movlw	GPA_ON	;PORTA p39: on state
	movwf	PORTA
	bcf	tri_b,5	;led_on
	movlw	PGON	;set power good counter
	movwf	pgctr
	goto	halfon2
	
;-------- power button low ----------------------------------------------------

but_low	bcf	tri_b,6
	goto	set_tris
	
;-------- power button high ---------------------------------------------------
	
but_high	bsf	tri_b,6
	goto	set_tris
	
;-------- read switch setting -------------------------------------------------
	
read_sw	movf	PORTB,w
	andlw	b'00001111'	;significant bits
	xorlw	b'00001111'	;invert, jumper 1 = 1
	movwf	switch
	return
	
;-------- read ADC ------------------------------------------------------------
	
read_adc	bsf	ADCON0,2	;set go bit
readad1	btfsc	ADCON0,2	;wait until it is clear again
	  goto	readad1
	movf	ADRESH,w	;get the result
	return	

;-------- setting the 'not_never' flag --------------------------------------------
not_never
	movlw	01h
	movwf	check_never ;set check_never to 1
	return

;-------- checking in the OFFDELAY if the J8 wasn't used  -------------------------
check_alternate_swith
	movfw	ignition_was_off ; was the ignition turned off and on during OFFDELAY ?
	skpnz
		goto	end_check_alternate_swith	; it was not. do nothing.

	movlw	0h
	movwf	ignition_was_off ; set initial state to 0.

	btfsc	PORTA,3
		goto	end_check_alternate_swith ; if the computer wasn't off then do nothing

	; wait 5 seconds
	movlw	ONDELAY	;wait for ONDELAY2
	movwf	cntr1h
check_loop	call	delay200	;wait
	decfsz	cntr1h,f	
	  goto	check_loop
	; check that ignition is still on
	btfss	PORTA,1	;ignition on ?
	  goto	end_check_alternate_swith; yes: don't start the computer
	
	; check for SureStop mode
	call	read_sw
	movfw	switch
	sublw	SURESTOP
	skpnz
		goto	end_check_alternate_swith

	; the computer was turned off. push the power on to get it back up
	call	but_low	;push the button
	movlw	BUTTON	;wait for BUTTON
	movwf	cntr1h
cas_button2	call	on200	;on state process
	decfsz	cntr1h,f	
	  goto	cas_button2
	call	but_high	;release the button

end_check_alternate_swith
	return

;-------- blink me --------------------
blink_me
	call led_off
	call delay200
	call led_on
	call delay200
	call led_off
	call delay200
	call led_on
	return
;-------- stop and signal ------------
start_signaling
	call blink_me
	call delay200
	goto start_signaling

;-------- reset entry ---------------------------------------------------------

reset	clrwdt

	banksel	OSCCON	;oscillator control p38
	movlw	b'01000000'	;1 MHz clock
	movwf	OSCCON	;NOTE: if changing clock speed,
			;must adjust ADCON0 and delay routines.

	banksel	OPTION_REG	;option register p17, p54
	movlw	b'01000000'	;enable PORTB pull-up
	movwf	OPTION_REG

;	banksel	PIE1	;peripheral interrupt enable p19
;	movlw	b'00000000'	;all off
;	movwf	PIE1

;	banksel	PIE2	;peripheral interrupt enable p21
;	movlw	b'00000000'	;all off
;	movwf	PIE2

;	banksel	INTCON	;interrupt control p18
;	movlw	b'00000000'	;disable all
;	movwf	INTCON

;	banksel	PIR1	;peripheral int status p20
;	movlw	b'00000000'	;clear
;	movwf	PIR1

;	banksel	PIR2	;peripheral int status p21
;	movlw	b'00000000'	;clear
;	movwf	PIR2

	banksel	ADCON1	;configure analog pins
	movlw	b'00001110'	;RA0 only, others digital, AVDD ref.
	movwf	ADCON1	;left justified
	
	banksel	0	;init ADC
	movlw	b'00000001'	;fosc/2, channel 0, ADC on
	movwf	ADCON0
	
	movlw	HIGH offtabl	;table page
	movwf	PCLATH
	
	movlw	HEARTBEAT	;init timer
	movwf	TMR1H
	clrf	TMR1L
	movlw	b'00000001'	;1:1 prescale, osc off, internal
	movwf	T1CON	;clock, timer 1 enable
	bcf	PIR1,0	;clear timer overrun bit

	movlw	GPA_OFF	;PORTA p39: off state
	movwf	PORTA
	movlw	b'00000000'	;PORTB p44: all low / input
	movwf	PORTB
	
	movlw	b'00101111'	;RA0..3 input, RA4, RA6..7 output
	movwf	tri_a	;5V power off
	movlw	b'01101111'	;RB0..3 input, LED off, RB6 input,
	movwf	tri_b	;power bad
	call	set_tris	;set tristate registers

	bcf	keep_amp_off,1;

	; hard power off

reset2	call	fulloff
	call	led_off
	
	call	read_sw	;read DIP switch status
	movf	switch,w	;switch setting = 0 ?
	btfsc	STATUS,Z
	  goto	turnon	;yes: skip ignition wait

	; initial power on - wait for ignition on
	
initial	movlw	ONDELAY
	movwf	cntr1h
	
initwait	call	delay200	;wait
	call	read_adc	;read ADC channel 0
          sublw	VSW12	;compare with threshold
	btfsc	STATUS,C	;low bat: clear counter
	  goto	initial
	btfss	PORTA,1	;ignition high ?
	  goto	initial	;no: clear counter
	decfsz	cntr1h,f	;initial time-out
	  goto	initwait
	
	; turn power on, wait ONDELAY2
	
turnon	call	halfon	;enable 5V standby supply
	movlw	ONDELAY2	;wait for ONDELAY2
	movwf	cntr1h
turnon1	call	delay200	;wait
	decfsz	cntr1h,f	
	  goto	turnon1

	movf	switch,w	;switch setting = 0 ?
	btfsc	STATUS,Z
	  goto	turnon2	;yes: skip voltage check
	
	call	read_adc	;read ADC channel 0
          sublw	VSW12	;compare with threshold
	btfsc	STATUS,C	;low bat: clear counter
	  goto	reset2
turnon2

	; check for SureStop mode
	call	read_sw
	movfw	switch
	sublw	SURESTOP
	skpnz
		goto	skip_button1

	; push the system board power button
	call	but_low	;push the button
	movlw	BUTTON	;wait for BUTTON
	movwf	cntr1h
button1	call	on200	;on state process
	decfsz	cntr1h,f	
	  goto	button1
    call	but_high	;release the button

skip_button1
	; power on state - shut down if ignition off for OFFDELAY

	movlw	0h
	movwf	ignition_was_off ; set initial state to 0.

onstate	
	call	check_alternate_swith ; check if we need to restart the motherboard because of a J8 usage during OFFDELAY
	call	read_sw	;set OFFDELAY counter
	call	offtabl
	movwf	cntr1l
	call	offtabh
	movwf	cntr1h

onstate1	call	on200	;on state process
	btfsc	PORTA,1	;ignition on ?
	  goto	onstate	;yes: reset timer
	movlw	1h
	movwf	ignition_was_off ; set the flag because we have an ignition_off event
	movfw	cntr1l	;counter 0 ?
	iorwf	cntr1h,w
	btfsc	STATUS,Z
	  goto	onstate1	;yes: ignore ignition
	decfsz	cntr1l,f	;count down
	  goto	onstate1
	decfsz	cntr1h,f
	  goto	onstate1
	
	; don't push the power button if the computer is already off
	btfss	PORTA,3
	  goto	skip_off_button

	; turn off amplifier before pushing the power button
	bcf	PORTB,4
	call	delay200
	call 	delay200

	; shut down - push the system board power button

	movlw	1h
	movwf	keep_amp_off
	
	call	but_low	;push the button
	movlw	BUTTON	;wait for BUTTON
	movwf	cntr1h
button2	bsf	keep_amp_off,1
	call	on200	;on state process
	decfsz	cntr1h,f	
	  goto	button2
	call	but_high	;release the button

skip_off_button
	; turn-off state - turn off power after HARDOFF
	; go back to restart after ONDELAY

	call	read_sw	;set HARDOFF counter
	call	hardtabl
	movwf	cntr1l
	call	hardtabh
	movwf	cntr1h

	movlw	0h
	movwf	check_never ;init check_never with 0
;	movfw	cntr1l
;	skpz
;		call	not_never ; if cntrll <> 0 set check_never to 1
;	movfw	cntr1h
;	skpz
;		call	not_never ; if cntr1h <> 0 set check_never to 1
	movfw	cntr1l
	sublw	NNV1
	skpz
		call	not_never ; if cntrll <> 0 set check_never to 1
	movfw	cntr1h
	sublw	NNV2
	skpz
		call	not_never ; if cntr1h <> 0 set check_never to 1

	movlw	ONDELAY
	movwf	cntr2h
	
	movlw	LEDCNTNORMAL	;set LED counter
	movwf	ledctr

shut0	movlw	LOW LOWOFF	;reset low battery counter
	movwf	cntr3l
	movlw	(HIGH LOWOFF)+.1
	movwf	cntr3h
	movlw LEDCNTNORMAL
	movwf ledcounter

shut1	incf	ledctr,f
	decfsz	ledctr,f	;LED counter = 0 ?
	  goto	shut1a
	movfw	ledcounter	;reset counter
	movwf	ledctr
	goto	shut1b
	
shut1a	decfsz	ledctr,f	;LED counter = 1 ?
 	  goto	shut1c	;:no
shut1b 	call	led_inv	;flash LED by inversion
shut1c
	bsf	keep_amp_off,1
	call	on200	;on state process
	btfss	PORTA,1	;ignition on ?
	  goto	shut2	;:no
	decfsz	cntr2h,f
	  goto	shut3
	; changed from goto turnon to goto turnon2 to fix the RESET when coming out of STANDBY
	goto	turnon2	;go turn-on if ignition on for ONDELAY

shut2	movlw	ONDELAY	;ignition off - restart on timer
	movwf	cntr2h
	
shut3	decfsz	cntr1l,f
  	  goto	shut4
	decfsz	cntr1h,f
	  goto	shut4	;keep waiting
	movfw	check_never
	skpnz
		goto shut4	;keep waiting even if counter have reached 0. 'never' situation
	goto	reset2	;do hard power off

shut4	call	read_adc	;read ADC channel 0
          sublw	VSW12	;compare with threshold
	btfss	STATUS,C	;ok bat: clear counter
	  goto	shut0
	movlw LEDCNTLOW
	movwf ledcounter
	decfsz	cntr3l,f	;LOWOFF countdown
	  goto	shut1
	decfsz	cntr3h,f
	  goto	shut1
	goto	reset2	;do hard power off

;------------------------------------------------------------------------------

	; on state loop, this routine runs ~ 200 ms before returning
	; to outer loop

on200	clrwdt		;clear watchdog
	movlw	HRTCNT	;set HRT counter
	movwf	hrt
	
	; amplifier anti-thump
	
	decfsz	ampctr,f	;end of amplifier delay ?
	  goto	on210	;:no
	incf	ampctr,f	;return to 1 state
	
	movlw	b'00010000'	;set PORTB,4 -> enable amp
	btfsc	PORTA,5	;PSON# low ?
	  movlw b'00000000'	;clear PORTB,4 -> disable amp
	btfsc	keep_amp_off,1
	  movlw b'00000000'	;clear PORTB,4 -> disable amp
	movwf	PORTB
	
	bcf	keep_amp_off,1
	; power on/off, power good	

on210	btfss	PIR1,0	;did the timer overflow ?
	  goto	on215	;:no
	movlw	HEARTBEAT	;reset the timer
	movwf	TMR1H
	bcf	PIR1,0	;clear the timer flag
	decf	pgctr,f	;decrement power good counter
	decfsz	hrt,f	;another poll ?
	  goto	on215
	return		;0 = return
	
	; check power status
	
on215	btfsc	PORTA,6	;ON set ?
	  goto	on230	;:on state
	
	; off state
	
	btfss	PORTA,5	;PSON# low ?
	  goto	on220	;:yes
	movlw	PSON
	movwf	psonctr	;reset the counter if PSON# high
	goto	on210	;back to poll loop
	
	; off state, PSON# low
	
on220	decfsz	psonctr,f	;debounce
	  goto	on210	;not yet - keep polling
	call	fullon	;turn on PSU
	movlw	PSOFF
	movwf	psoffctr	;reset turn-off counter
	goto	on210	;back to poll loop

	; on state, PSON# low
	
on230	btfsc	PORTA,5	;PSON# low ?
	  goto	on240	;:no
	movlw	PSOFF	;reset turn-off counter
	movwf	psoffctr
	
	; look whether power is good

	movlw	PGOFF	;poll count for power bad debounce
	movwf	pbad
on231	btfss	PORTA,2	;PGOOD1 low ?
	  goto	on232	;yes: bad
	btfsc	PORTA,3	;VS3 low ?
	  goto	on235	;no :power good
on232	decfsz	pbad,f	;try again ?
	  goto	on231
	
	; power is bad
	
	movlw	PGON	;reset the power good counter
	movwf	pgctr
	bcf	tri_b,7	;power good low
	call	set_tris
	goto	on210
	
	; power is good - do transition ?
	
on235	btfsc	tri_b,7	;power good already set ?
	  goto	on210	;yes -> back to poll loop
	movf	pgctr,w	;counter zero ?
	btfss	STATUS,Z
	  goto	on210	;:not yet
	bsf	tri_b,7	;power good open drain
	call	set_tris
	goto	on210
	
	; on state, PSON# high

on240	btfsc	PORTB,4
	  bcf	PORTB,4
	decfsz	psoffctr,f
 	  goto	on210	;:not yet - keep polling
 	call	halfon	;turn off PSU
 	movlw	PSON
 	movwf	psonctr	;reset turn-on counter
 	goto	on210	;back to poll loop

;-------- config tables -------------------------------------------------------

	org	.768	;all in this page, so PCLATH is right
				;counts are always + 1 for decfsz !	

offtabl	movfw	switch
	addwf	PCL,f
	retlw	.0	;switch 0: never
	retlw	.26	;switch 1: 5 s
	retlw	.26	;switch 2: 5 s
	retlw	.26	;switch 3: 5 s
	retlw	.151	;switch 4: 30 s
	retlw	.151	;switch 5: 30 s
	retlw	.0	;switch 6: 30 min
	retlw	.0	;switch 7: 3 hrs
	retlw	.0	;switch 8: 10 min
	retlw	.0	;switch 9: 15 min
	retlw	.0	;switch 10: 1 hour
	retlw	.26	;switch 11: 5 s

offtabh	movfw	switch
	addwf	PCL,f
	retlw	.0	;switch 0: never
	retlw	.1	;switch 1: 5 s
	retlw	.1	;switch 2: 5 s
	retlw	.1	;switch 3: 5 s
	retlw	.1	;switch 4: 30 s
	retlw	.1	;switch 5: 30 s
	retlw	.36	;switch 6: 30 min
	retlw	.212	;switch 7: 3 hrs
	retlw	.11	;switch 8: 10 min
	retlw	.18	;switch 9: 15 min
	retlw	.70	;switch 10: 1 hour
	retlw	.1	;switch 11: 5 s

hardtabl	movfw	switch
	addwf	PCL,f
	retlw	.0	;switch 0: never
	retlw	.50	;switch 1: 1 min
	retlw	.0	;switch 2: 2 hrs
	retlw	.0	;switch 3: never
	retlw	.0	;switch 4: 2 hrs
	retlw	.0	;switch 5: never
	retlw	.0	;switch 6: never
	retlw	.0	;switch 7: never
	retlw	.0	;switch 8: 1 hrs
	retlw	.0	;switch 9: 2 hrs
	retlw	.0	;switch 10: 1h 15min
	retlw	.0	;switch 11: 2 hrs

hardtabh	movfw	switch
	addwf	PCL,f
	retlw	.0	;switch 0: never
	retlw	.2	;switch	1: 1 min
	retlw	.142	;switch 2: 2 hrs
	retlw	.0	;switch 3: never
	retlw	.142	;switch 4: 2 hrs
	retlw	.0	;switch 5: never
	retlw	.0	;switch 6: never
	retlw	.0	;switch 7: never
	retlw	.70	;switch 8: 1 hrs
	retlw	.142	;switch 9: 2 hrs
	retlw	.88	;switch 10: 1h 15min
	retlw	.142	;switch	11: 2 hrs

;-------- define configuration bits -------------------------------------------

	__config _LVP_OFF & _WDT_OFF & _MCLR_OFF & _PWRTE_ON & _INTRC_IO

	END
