#include <stdio.h>
#include <inttypes.h>
#include "lite-qmi-uim.h"
#include "uim.h"

typedef struct
{
	uint32_t status;
	const char* szStatus;
}Map_Status;

static Map_Status g_Table_PhyCardStatus[] =
{
  {0, "Unknown"},
  {1, "Absent"},
  {2, "Present"},
};

static Map_Status g_Table_PhySlotStatus[] =
{
  {0, "Inactive"},
  {1, "Activate"},
};

static Map_Status g_Table_LogicalSlot[] =
{
  {1, "Slot 1"},
  {2, "Slot 2"},
  {3, "Slot 3"},
  {4, "Slot 4"},
  {5, "Slot 5"},
 };

void DisplaySlotsStatus(unpack_uim_SLQSUIMGetSlotsStatus_t *pSlotStatus)
{
    uint8_t idx = 0, jdx = 0;
    swi_uint256_print_mask (pSlotStatus->ParamPresenceMask);
    if((pSlotStatus->pNumberOfPhySlot) && (pSlotStatus->pUimSlotsStatus)  && (swi_uint256_get_bit (pSlotStatus->ParamPresenceMask, 16)))
    {
        printf("\nPhysical Slot Status Length:%d\n",*(pSlotStatus->pNumberOfPhySlot));
        for( idx = 0; idx < *(pSlotStatus->pNumberOfPhySlot); idx++)
        {
            printf("\t%d. Physical Card Status :%s\n", idx+1, g_Table_PhyCardStatus[pSlotStatus->pUimSlotsStatus->uimSlotStatus[idx].uPhyCardStatus].szStatus);
            printf("\t%d. Physical Slot Status :%s\n", idx+1, g_Table_PhySlotStatus[pSlotStatus->pUimSlotsStatus->uimSlotStatus[idx].uPhySlotStatus].szStatus);
            printf("\t%d. Logical Slot :%s\n", idx+1, g_Table_LogicalSlot[pSlotStatus->pUimSlotsStatus->uimSlotStatus[idx].bLogicalSlot].szStatus);
            printf("\t%d. ICCID Length :%d\n", idx+1, pSlotStatus->pUimSlotsStatus->uimSlotStatus[idx].bICCIDLength);
            printf("\t%d. ICCID :",idx+1);
            for(jdx=0; jdx<pSlotStatus->pUimSlotsStatus->uimSlotStatus[idx].bICCIDLength; jdx++)
                printf("%02X ",pSlotStatus->pUimSlotsStatus->uimSlotStatus[idx].bICCID[jdx]);
            printf("\n");
        }
    }
}

void DisplayVerifyPin(unpack_uim_VerifyPin_t *pVerifyPinResult)
{
    int lcount;

    swi_uint256_print_mask (pVerifyPinResult->ParamPresenceMask);
    printf("%s Result: %d\n",__FUNCTION__, pVerifyPinResult->Tlvresult);

     if (( NULL !=  pVerifyPinResult->pRemainingRetries ) && (swi_uint256_get_bit (pVerifyPinResult->ParamPresenceMask, 16)))
     {
         printf("Retry Remaining(Verify PIN) : %d \n",
                           pVerifyPinResult->pRemainingRetries->verifyLeft);
         printf("Retry Remaining(Unblock PIN): %d \n",
                           pVerifyPinResult->pRemainingRetries->unblockLeft);
     }
     if (( NULL !=  pVerifyPinResult->pEncryptedPIN1 ) && (swi_uint256_get_bit (pVerifyPinResult->ParamPresenceMask, 17)))
     {
         printf("Encrypted PIN1 Len : %d \n",
                           pVerifyPinResult->pEncryptedPIN1->pin1Len);
         printf("Encrypted PIN1 Value : ");
         for (lcount = 0;lcount < pVerifyPinResult->pEncryptedPIN1->pin1Len ;lcount++)
         {
             printf("%d,", pVerifyPinResult->pEncryptedPIN1->pin1Val[lcount]);
         }
         printf("\n");
     }
     if (( NULL != pVerifyPinResult->pIndicationToken ) && (swi_uint256_get_bit (pVerifyPinResult->ParamPresenceMask, 18)))
         printf("Indication Token : %d \n",*pVerifyPinResult->pIndicationToken);
}

void DisplayCardStatus(unpack_uim_GetCardStatus_t *pGetCardStatus)
{
    int lcount,lIcount1,lIcount;
    swi_uint256_print_mask (pGetCardStatus->ParamPresenceMask);
    printf("\n%s Result: %d\n",__FUNCTION__, pGetCardStatus->Tlvresult);
    if((pGetCardStatus->pCardStatus) && (swi_uint256_get_bit (pGetCardStatus->ParamPresenceMask, 16)))
    {
        printf("Index of the primary GW   : 0x%x\n",
                         pGetCardStatus->pCardStatus->indexGwPri);
        printf("Index of the primary 1X   : 0x%x\n",
                             pGetCardStatus->pCardStatus->index1xPri);
        printf("Index of the secondary GW : 0x%x\n",
                             pGetCardStatus->pCardStatus->indexGwSec);
        printf("Index of the secondary 1X : 0x%x\n",
                             pGetCardStatus->pCardStatus->index1xSec);
        printf("Slots Available           : 0x%x\n",
                             pGetCardStatus->pCardStatus->numSlot);
   
        for ( lcount=0 ; lcount < pGetCardStatus->pCardStatus->numSlot; lcount++ )
        {
            uim_slotInfo *temp = &pGetCardStatus->pCardStatus->SlotInfo[lcount];
            printf( "  Information for SLOT%d\n",lcount+1);
            printf( "  State of the Card         : %x\n", temp->cardState);
            printf( "  State of the UPIN         : %x\n", temp->upinState);
            printf( "  Retries Remaining(UPIN)   : %d\n", temp->upinRetries);
            printf( "  Retries Remaining(UPUK)   : %d\n", temp->upukRetries);
            printf( "  Reason For Error          : %x\n", temp->errorState);
            printf( "  No. of Apps Allowed       : %d\n", temp->numApp);
            for ( lIcount=0 ; lIcount < temp->numApp; lIcount++ )
            {
                uim_appStatus *lresp = &temp->AppStatus[lIcount];
                printf( "   Application Status Information for App%d\n",lIcount+1);
                printf( "   Type of Application       : 0x%x\n", lresp->appType);
                printf( "   State of Application      : 0x%x\n", lresp->appState);
                printf( "   State of perso for App    : 0x%x\n", lresp->persoState);
                printf( "   Indicates perso feature   : 0x%x\n", lresp->persoFeature);
                printf( "   Retries Remaining(Perso BL): %d\n",
                                     lresp->persoRetries);
                printf( "    Retries Remaining(Perso UB): %d\n",
                                     lresp->persoUnblockRetries);
                printf( "    Application Identifier Len: %d\n", lresp->aidLength);
                printf( "    Application Identifier Value : ");
                for ( lIcount1=0 ; lIcount1 < lresp->aidLength; lIcount1++ )
                {
                    printf( "%02x ", lresp->aidVal[lIcount1]);
                }
                printf("\n");
                printf( "    Indication for UPIN       : 0x%x\n", lresp->univPin);
                printf( "    Indicates State of Pin1   : 0x%x\n", lresp->pin1State);
                printf( "    Retries Remaining(PIN1)   : 0x%d\n", lresp->pin1Retries);
                printf( "    Retries Remaining(PUK1)   : 0x%d\n", lresp->puk1Retries);
                printf( "    Indicates State of Pin2   : 0x%x\n", lresp->pin2State);
                printf( "    Retries Remaining(PIN2)   : 0x%d\n", lresp->pin2Retries);
                printf( "    Retries Remaining(PUK2)   : 0x%d\n", lresp->puk2Retries);
            }
        }
    }
    if (( pGetCardStatus->pHotSwapStatus ) && (swi_uint256_get_bit (pGetCardStatus->ParamPresenceMask, 17)))
    {
        printf("Hot Swap Length           : %d\n",
                pGetCardStatus->pHotSwapStatus->hotSwapLength);
        printf("Status of HotSwap Switch  : ");
        for ( lcount=0 ; lcount < pGetCardStatus->pHotSwapStatus->hotSwapLength; lcount++ )
        {
            printf("%x", pGetCardStatus->pHotSwapStatus->hotSwap[lcount]);
        }
        printf("\n");
    }
}

void DisplaySetPinProtection(unpack_uim_SetPinProtection_t *pSetPinProtection)
{
    int lcount;
    swi_uint256_print_mask (pSetPinProtection->ParamPresenceMask);
    printf("%s Result: %d\n",__FUNCTION__, pSetPinProtection->Tlvresult);

    if (( NULL !=  pSetPinProtection->pRemainingRetries ) && (swi_uint256_get_bit (pSetPinProtection->ParamPresenceMask, 16)))
    {
        printf("Retry Remaining(Verify PIN) : %d \n",
                          pSetPinProtection->pRemainingRetries->verifyLeft);
        printf("Retry Remaining(Unblock PIN): %d \n",
                           pSetPinProtection->pRemainingRetries->unblockLeft);
    }
    if (( NULL !=  pSetPinProtection->pEncryptedPIN1 ) && (swi_uint256_get_bit (pSetPinProtection->ParamPresenceMask, 17)))
    {
        printf("Encrypted PIN1 Len : %d \n",
                    pSetPinProtection->pEncryptedPIN1->pin1Len);
        printf("Encrypted PIN1 Value : ");
        for (lcount = 0;lcount < pSetPinProtection->pEncryptedPIN1->pin1Len ;lcount++)
        {
            printf("%d,", pSetPinProtection->pEncryptedPIN1->pin1Val[lcount]);
        }
        printf("\n");
    }
    if (( NULL != pSetPinProtection->pIndicationToken ) && (swi_uint256_get_bit (pSetPinProtection->ParamPresenceMask, 18)))
        printf("Indication Token : %d \n",*pSetPinProtection->pIndicationToken);
}

void DisplayUnblockPin(unpack_uim_UnblockPin_t *pUnblockPinResult)
{
    int lcount;
    swi_uint256_print_mask (pUnblockPinResult->ParamPresenceMask);
    printf("%s Result: %d\n",__FUNCTION__, pUnblockPinResult->Tlvresult);
    
     if (( NULL !=  pUnblockPinResult->pRemainingRetries ) && (swi_uint256_get_bit (pUnblockPinResult->ParamPresenceMask, 16)))
     {
         printf("Retry Remaining(Verify PIN) : %d \n",
                           pUnblockPinResult->pRemainingRetries->verifyLeft);
         printf("Retry Remaining(Unblock PIN): %d \n",
                           pUnblockPinResult->pRemainingRetries->unblockLeft);
     }
     if (( NULL !=  pUnblockPinResult->pEncryptedPIN1 ) && (swi_uint256_get_bit (pUnblockPinResult->ParamPresenceMask, 17)))
     {
         printf("Encrypted PIN1 Len : %d \n",
                           pUnblockPinResult->pEncryptedPIN1->pin1Len);
         printf("Encrypted PIN1 Value : ");
         for (lcount = 0;lcount < pUnblockPinResult->pEncryptedPIN1->pin1Len ;lcount++)
         {
             printf("%d,", pUnblockPinResult->pEncryptedPIN1->pin1Val[lcount]);
         }
         printf("\n");
     }
     if (( NULL != pUnblockPinResult->pIndicationToken ) && (swi_uint256_get_bit (pUnblockPinResult->ParamPresenceMask, 18)))
         printf("Indication Token : %d \n",*pUnblockPinResult->pIndicationToken);
}

void DisplayFileAttributes(unpack_uim_SLQSUIMGetFileAttributes_t *pGetFileAttributesResp)
{
    uint16_t lcount;
    swi_uint256_print_mask (pGetFileAttributesResp->ParamPresenceMask);
    if (( NULL != pGetFileAttributesResp->pCardResult ) && (swi_uint256_get_bit (pGetFileAttributesResp->ParamPresenceMask, 16)))
        {
            printf( "SW1 received from card :%x\n", pGetFileAttributesResp->pCardResult->sw1 );
            printf( "SW2 received from card :%x\n", pGetFileAttributesResp->pCardResult->sw2 );
        }
    if (( NULL != pGetFileAttributesResp->pFileAttributes ) && (swi_uint256_get_bit (pGetFileAttributesResp->ParamPresenceMask, 17)))
        {
            printf( "File Size        : %d\n",pGetFileAttributesResp->pFileAttributes->fileSize);
            printf( "File ID          : %x\n",pGetFileAttributesResp->pFileAttributes->fileID);
            printf( "File Type        : %x\n",pGetFileAttributesResp->pFileAttributes->fileType);
            printf( "Record Size      : %d\n",pGetFileAttributesResp->pFileAttributes->recordSize);
            printf( "Record Count     : %d\n",pGetFileAttributesResp->pFileAttributes->recordCount);
            printf( "Security Read    : %x\n",pGetFileAttributesResp->pFileAttributes->secRead);
            printf( "Security Read M  : %x\n",pGetFileAttributesResp->pFileAttributes->secReadMask);
            printf( "Security Write   : %x\n",pGetFileAttributesResp->pFileAttributes->secWrite);
            printf( "Security Write M : %x\n",pGetFileAttributesResp->pFileAttributes->secWriteMask);
            printf( "Security Inc     : %x\n",pGetFileAttributesResp->pFileAttributes->secIncrease);
            printf( "Security Inc M   : %x\n",pGetFileAttributesResp->pFileAttributes->secIncreaseMask);
            printf( "Security De-Act  : %x\n",pGetFileAttributesResp->pFileAttributes->secDeactivate);
            printf( "Security De-Act M: %x\n",pGetFileAttributesResp->pFileAttributes->secDeactivateMask);
            printf( "Security Act     : %x\n",pGetFileAttributesResp->pFileAttributes->secActivate);
            printf( "Security Act M   : %x\n",pGetFileAttributesResp->pFileAttributes->secActivateMask);
            printf( "Raw Len          : %d\n",pGetFileAttributesResp->pFileAttributes->rawLen);
            printf( "Raw Value        : ");
            for ( lcount=0 ; lcount < pGetFileAttributesResp->pFileAttributes->rawLen ; lcount++ )
                {
                    printf( "%x ",pGetFileAttributesResp->pFileAttributes->rawValue[lcount]);
                }
        }
    printf( "\n");
    if((pGetFileAttributesResp->pIndicationToken != NULL) && (swi_uint256_get_bit (pGetFileAttributesResp->ParamPresenceMask, 18)))
        printf( "Indication Token : %x\n",*pGetFileAttributesResp->pIndicationToken );
    if((pGetFileAttributesResp->pFileStatus != NULL) && (swi_uint256_get_bit (pGetFileAttributesResp->ParamPresenceMask, 19)))
        printf( "File Status : %x\n",*pGetFileAttributesResp->pFileStatus);
    printf("%s done\n", __func__);
}

void DisplayAuthenticate(unpack_uim_SLQSUIMAuthenticate_t *pAuthenticateResp)
{
    uint16_t lcount;

    swi_uint256_print_mask (pAuthenticateResp->ParamPresenceMask);
    if (( NULL != pAuthenticateResp->pCardResult ) && (swi_uint256_get_bit (pAuthenticateResp->ParamPresenceMask, 16)))
    {
        printf( "SW1 received from card :%x", pAuthenticateResp->pCardResult->sw1 );
        printf( "SW2 received from card :%x", pAuthenticateResp->pCardResult->sw2 );
    }
    if (( NULL != pAuthenticateResp->pAuthenticateResult ) && (swi_uint256_get_bit (pAuthenticateResp->ParamPresenceMask, 17)))
    {
        printf( "Content Len  : %d\n",pAuthenticateResp->pAuthenticateResult->contentLen );
        printf( "Content      : ");
        for ( lcount=0 ; lcount < pAuthenticateResp->pAuthenticateResult->contentLen ; lcount++ )
        {
            printf( "%c",pAuthenticateResp->pAuthenticateResult->content[lcount]);
        }
        printf( "\n");
    }
    if((pAuthenticateResp->pIndicationToken != NULL) && (swi_uint256_get_bit (pAuthenticateResp->ParamPresenceMask, 18)))
        printf( "Indication Token : %x\n",*pAuthenticateResp->pIndicationToken );
}

void DisplayConfiguration(unpack_uim_SLQSUIMGetConfiguration_t *pGetConfigurationResp)
{
    uint16_t count;
    swi_uint256_print_mask (pGetConfigurationResp->ParamPresenceMask);
    if((NULL != pGetConfigurationResp->pAutoSelection) && (swi_uint256_get_bit (pGetConfigurationResp->ParamPresenceMask, 16)))
        printf( "Automatic Selection : 0x%X \n",*pGetConfigurationResp->pAutoSelection);
    if (( NULL != pGetConfigurationResp->pPersonalizationStatus ) && (swi_uint256_get_bit (pGetConfigurationResp->ParamPresenceMask, 17)))
        {
            printf( "Personalization Status: Num features = %d\n", pGetConfigurationResp->pPersonalizationStatus->numFeatures );
            for(count=0; count < pGetConfigurationResp->pPersonalizationStatus->numFeatures;count++)
                {
                    printf( "0x%X \n",pGetConfigurationResp->pPersonalizationStatus->feature[count] );
                    printf( "0x%X \n",pGetConfigurationResp->pPersonalizationStatus->verifyLeft[count]);
                    printf( "0x%X \n",pGetConfigurationResp->pPersonalizationStatus->unblockLeft[count] );
                    }
                }
    if((NULL != pGetConfigurationResp->pHaltSubscription) && (swi_uint256_get_bit (pGetConfigurationResp->ParamPresenceMask, 18)))
        printf( "HALT Subscription : 0x%X \n", *pGetConfigurationResp->pHaltSubscription);
}

void DisplayChangePin(unpack_uim_ChangePin_t *pChangePinResp)
{
    int lcount;
    swi_uint256_print_mask (pChangePinResp->ParamPresenceMask);
    printf("%s Result: %d\n",__FUNCTION__, pChangePinResp->Tlvresult);

     if (( NULL !=  pChangePinResp->pRemainingRetries ) && (swi_uint256_get_bit (pChangePinResp->ParamPresenceMask, 16)))
     {
         printf("Retry Remaining(Verify PIN) : %d \n",
                           pChangePinResp->pRemainingRetries->verifyLeft);
         printf("Retry Remaining(Unblock PIN): %d \n",
                           pChangePinResp->pRemainingRetries->unblockLeft);
     }
     if (( NULL !=  pChangePinResp->pEncryptedPIN1 ) && (swi_uint256_get_bit (pChangePinResp->ParamPresenceMask, 17)))
     {
         printf("Encrypted PIN1 Len : %d \n",
                           pChangePinResp->pEncryptedPIN1->pin1Len);
         printf("Encrypted PIN1 Value : ");
         for (lcount = 0;lcount < pChangePinResp->pEncryptedPIN1->pin1Len ;lcount++)
         {
             printf("%d,", pChangePinResp->pEncryptedPIN1->pin1Val[lcount]);
         }
         printf("\n");
     }
     if (( NULL != pChangePinResp->pIndicationToken ) && (swi_uint256_get_bit (pChangePinResp->ParamPresenceMask, 18)))
         printf("Indication Token : %d \n",*pChangePinResp->pIndicationToken);
}

void DisplayGetLastEvent(unpack_uim_SLQSUIMRefreshGetLastEvent_t *pRefreshGetLastEventResp)
{
    uint16_t lCount;
    uint16_t lIcount;

    swi_uint256_print_mask (pRefreshGetLastEventResp->ParamPresenceMask);
    if((pRefreshGetLastEventResp->pRefreshEvent!=NULL) && (swi_uint256_get_bit (pRefreshGetLastEventResp->ParamPresenceMask, 16)))
    {
        printf("Parameter Indication refresh\n");
        printf("Stage:      %d\n", pRefreshGetLastEventResp->pRefreshEvent->stage );
        printf("Mode:       %d\n", pRefreshGetLastEventResp->pRefreshEvent->mode );
        printf("sessionType:%d\n", pRefreshGetLastEventResp->pRefreshEvent->sessionType);
        printf("aidLength: %d\n", pRefreshGetLastEventResp->pRefreshEvent->aidLength);

        uim_refreshevent *pTemp = pRefreshGetLastEventResp->pRefreshEvent;
        for ( lCount = 0; lCount < pTemp->aidLength ; lCount++ )
        {
            printf("Mode of Refresh = %d\n", pTemp->aid[lCount]);
        }

        printf(" Number of files = %d\n", pTemp->numOfFiles);
        for ( lCount = 0; lCount < pTemp->numOfFiles; lCount++ )
        {
            printf("FileID= %d\n", pRefreshGetLastEventResp->pRefreshEvent->arrfileInfo[lCount].fileID);
            printf("Path Length = %d\n", pRefreshGetLastEventResp->pRefreshEvent->arrfileInfo[lCount].pathLen);
            for ( lIcount = 0;lIcount < pRefreshGetLastEventResp->pRefreshEvent->arrfileInfo[lCount].pathLen; lIcount++ )
            {
                printf(" Path = %x", pRefreshGetLastEventResp->pRefreshEvent->arrfileInfo[lCount].path[lIcount]);
            }
        }
    }
}

void DisplayGetFileAttributesInd(unpack_uim_SLQSUIMGetFileAttibutes_Ind_t *pGetFileAttributesInd)
{
    swi_uint256_print_mask (pGetFileAttributesInd->ParamPresenceMask);

    if (swi_uint256_get_bit (pGetFileAttributesInd->ParamPresenceMask, 1))
    {
        printf( "Indication Token:%x\n", pGetFileAttributesInd->indication_token );
    }
    if (swi_uint256_get_bit (pGetFileAttributesInd->ParamPresenceMask, 0x10))
    {
        printf( "SW1 received from card :%x\n", pGetFileAttributesInd->cardResult.sw1 );
        printf( "SW2 received from card :%x\n", pGetFileAttributesInd->cardResult.sw2 );
    }
    if (swi_uint256_get_bit (pGetFileAttributesInd->ParamPresenceMask, 0x11))
    {
        int lcount;

        printf( "File Size        : %d\n",pGetFileAttributesInd->fileAttributes.fileSize);
        printf( "File ID          : %x\n",pGetFileAttributesInd->fileAttributes.fileID);
        printf( "File Type        : %x\n",pGetFileAttributesInd->fileAttributes.fileType);
        printf( "Record Size      : %d\n",pGetFileAttributesInd->fileAttributes.recordSize);
        printf( "Record Count     : %d\n",pGetFileAttributesInd->fileAttributes.recordCount);
        printf( "Security Read    : %x\n",pGetFileAttributesInd->fileAttributes.secRead);
        printf( "Security Read M  : %x\n",pGetFileAttributesInd->fileAttributes.secReadMask);
        printf( "Security Write   : %x\n",pGetFileAttributesInd->fileAttributes.secWrite);
        printf( "Security Write M : %x\n",pGetFileAttributesInd->fileAttributes.secWriteMask);
        printf( "Security Inc     : %x\n",pGetFileAttributesInd->fileAttributes.secIncrease);
        printf( "Security Inc M   : %x\n",pGetFileAttributesInd->fileAttributes.secIncreaseMask);
        printf( "Security De-Act  : %x\n",pGetFileAttributesInd->fileAttributes.secDeactivate);
        printf( "Security De-Act M: %x\n",pGetFileAttributesInd->fileAttributes.secDeactivateMask);
        printf( "Security Act     : %x\n",pGetFileAttributesInd->fileAttributes.secActivate);
        printf( "Security Act M   : %x\n",pGetFileAttributesInd->fileAttributes.secActivateMask);
        printf( "Raw Len          : %d\n",pGetFileAttributesInd->fileAttributes.rawLen);
        printf( "Raw Value        : ");
        for ( lcount=0 ; lcount < pGetFileAttributesInd->fileAttributes.rawLen ; lcount++ )
        {
            printf( "%x ",pGetFileAttributesInd->fileAttributes.rawValue[lcount]);
        }
    }
    printf( "\n");

    if(swi_uint256_get_bit (pGetFileAttributesInd->ParamPresenceMask, 0x12))
        printf( "File Status : %x\n",pGetFileAttributesInd->file_status);
    printf("\n");
}

void DisplaySlotStatusChangeInd(unpack_uim_SetUimSlotStatusChangeCallback_ind_t *pSlotStatusChangeCallback_ind)
{
    if(swi_uint256_get_bit (pSlotStatusChangeCallback_ind->ParamPresenceMask, 16))
    {
        printf("Slot Status Change Indication:\n");

        for (int idx = 0; idx < pSlotStatusChangeCallback_ind->bNumberOfPhySlots; ++idx)
        {            
            printf("  State of the card in the Pyhsical Slot Status = %d\n", 
                    pSlotStatusChangeCallback_ind->slotsstatusChange.uimSlotStatus[idx].uPhyCardStatus);            
            printf("  State of the Physical Slot status = %d\n", 
                    pSlotStatusChangeCallback_ind->slotsstatusChange.uimSlotStatus[idx].uPhySlotStatus);            
            printf("  Logical Slot associated with this physical slot = %d\n", 
                    pSlotStatusChangeCallback_ind->slotsstatusChange.uimSlotStatus[idx].bLogicalSlot);

            printf("  ICCID of the card in the physical slot: ");
            for (int idy = 0; idy < pSlotStatusChangeCallback_ind->slotsstatusChange.uimSlotStatus[idx].bICCIDLength; ++idy)
            {
                printf("%d", pSlotStatusChangeCallback_ind->slotsstatusChange.uimSlotStatus[idx].bICCID[idy]);
            }
            printf("\n");
        }
    }
}
