// FileRecordDialog.cpp : implementation file
//

#include "stdafx.h"
#include "SC510.h"
#include "SC510Dlg.h"
#include "FileRecordDialog.h"
#include "afxdialogex.h"

// CFileRecordDialog dialog

IMPLEMENT_DYNAMIC(CFileRecordDialog, CDialog)

CFileRecordDialog::CFileRecordDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CFileRecordDialog::IDD, pParent)
{

}

CFileRecordDialog::~CFileRecordDialog()
{
}

void CFileRecordDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFileRecordDialog)
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_4_2_, m_edit_record_4_2);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_4_1_, m_edit_record_4_1);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_3_2_, m_edit_record_3_2);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_3_1_, m_edit_record_3_1);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_2_2_, m_edit_record_2_2);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_2_1_, m_edit_record_2_1);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_1_2, m_edit_record_1_2);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH_1_1, m_edit_record_1_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_4_2_, m_btnRecordStop_4_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_4_1_, m_btnRecordStop_4_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_3_2_, m_btnRecordStop_3_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_3_1_, m_btnRecordStop_3_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_2_2_, m_btnRecordStop_2_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_2_1_, m_btnRecordStop_2_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_1_2, m_btnRecordStop_1_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_STOP_1_1, m_btnRecordStop_1_1);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_4_2_, m_checkGPU_4_2);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_4_1_, m_checkGPU_4_1);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_3_2_, m_checkGPU_3_2);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_3_1_, m_checkGPU_3_1);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_2_2_, m_checkGPU_2_2);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_2_1_, m_checkGPU_2_1);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_1_2, m_checkGPU_1_2);
	DDX_Control(pDX, IDC_CHECK_GPU_SUPPORT_1_1, m_checkGPU_1_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_4_2_, m_btnRecordStart_4_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_4_1_, m_btnRecordStart_4_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_3_2_, m_btnRecordStart_3_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_3_1_, m_btnRecordStart_3_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_2_2_, m_btnRecordStart_2_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_2_1_, m_btnRecordStart_2_1);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_1_2, m_btnRecordStart_1_2);
	DDX_Control(pDX, IDC_BUTTON_RECORD_START_1_1, m_btnRecordStart_1_1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFileRecordDialog, CDialog)
	//{{AFX_MSG_MAP(CFileRecordDialog)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_1_1, OnButtonRecordStart11)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_1_1, OnButtonRecordStop11)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_1_2, OnButtonRecordStart12)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_1_2, OnButtonRecordStop12)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_2_1_, OnButtonRecordStart21)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_2_1_, OnButtonRecordStop21)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_2_2_, OnButtonRecordStart22)
	ON_BN_CLICKED(IDC_SCFA_RADIO_1_1, OnScfARadio11)
	ON_BN_CLICKED(IDC_SCFB_RADIO_1_1, OnScfBRadio11)
	ON_BN_CLICKED(IDC_SCFA_RADIO_1_2, OnScfARadio12)
	ON_BN_CLICKED(IDC_SCFB_RADIO_1_2, OnScfBRadio12)
	ON_BN_CLICKED(IDC_SCFA_RADIO_2_1, OnScfARadio21)
	ON_BN_CLICKED(IDC_SCFB_RADIO_2_1, OnScfBRadio21)
	ON_BN_CLICKED(IDC_SCFA_RADIO_2_2_, OnScfARadio22)
	ON_BN_CLICKED(IDC_SCFB_RADIO_2_2_, OnScfBRadio22)
	ON_BN_CLICKED(IDC_SCFA_RADIO_3_1_, OnScfARadio31)
	ON_BN_CLICKED(IDC_SCFB_RADIO_3_1_, OnScfBRadio31)
	ON_BN_CLICKED(IDC_SCFA_RADIO_3_2_, OnScfARadio32)
	ON_BN_CLICKED(IDC_SCFB_RADIO_3_2_, OnScfBRadio32)
	ON_BN_CLICKED(IDC_SCFA_RADIO_4_1, OnScfARadio41)
	ON_BN_CLICKED(IDC_SCFB_RADIO_4_1, OnScfBRadio41)
	ON_BN_CLICKED(IDC_SCFA_RADIO_4_2, OnScfARadio42)
	ON_BN_CLICKED(IDC_SCFB_RADIO_4_2, OnScfBRadio422)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_2_2_, OnButtonRecordStop22)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_3_1_, OnButtonRecordStart31)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_3_2_, OnButtonRecordStart32)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_3_1_, OnButtonRecordStop31)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_3_2_, OnButtonRecordStop32)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_4_1_, OnButtonRecordStart41)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_4_1_, OnButtonRecordStop41)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_START_4_2_, OnButtonRecordStart42)
	ON_BN_CLICKED(IDC_BUTTON_RECORD_STOP_4_2_, OnButtonRecordStop42)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// CFileRecordDialog message handlers

BOOL CFileRecordDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();	
	
	m_strFullPath1 = m_pMainDialog->GetWorkingPath( "00_CH01M.SCF" );	

	m_edit_record_1_1.SetWindowText( (LPCTSTR)m_strFullPath1 );

	m_strFullPath2 = m_pMainDialog->GetWorkingPath( "01_CH01S.SCF" );	

	m_edit_record_1_2.SetWindowText( (LPCTSTR)m_strFullPath2 );

	m_strFullPath3 = m_pMainDialog->GetWorkingPath( "02_CH02M.SCF" );

	m_edit_record_2_1.SetWindowText( (LPCTSTR)m_strFullPath3 );

	m_strFullPath4 = m_pMainDialog->GetWorkingPath( "03_CH02S.SCF" );

	m_edit_record_2_2.SetWindowText( (LPCTSTR)m_strFullPath4 );

	m_strFullPath5 = m_pMainDialog->GetWorkingPath( "04_CH03M.SCF" );

	m_edit_record_3_1.SetWindowText( (LPCTSTR)m_strFullPath5 );

	m_strFullPath6 = m_pMainDialog->GetWorkingPath( "05_CH03S.SCF" );

	m_edit_record_3_2.SetWindowText( (LPCTSTR)m_strFullPath6 );

	m_strFullPath7 = m_pMainDialog->GetWorkingPath( "06_CH04M.SCF" );

	m_edit_record_4_1.SetWindowText( (LPCTSTR)m_strFullPath7 );

	m_strFullPath8 = m_pMainDialog->GetWorkingPath( "07_CH04S.SCF" );

	m_edit_record_4_2.SetWindowText( (LPCTSTR)m_strFullPath8 );	

	CheckDlgButton( IDC_SCFA_RADIO_1_1, BST_UNCHECKED );

	CheckDlgButton( IDC_SCFA_RADIO_1_2, BST_UNCHECKED );

	CheckDlgButton( IDC_SCFA_RADIO_2_1, BST_UNCHECKED );

	CheckDlgButton( IDC_SCFA_RADIO_2_2_, BST_UNCHECKED );

	CheckDlgButton( IDC_SCFA_RADIO_3_1_, BST_UNCHECKED );

	CheckDlgButton( IDC_SCFA_RADIO_3_2_, BST_UNCHECKED );

	CheckDlgButton( IDC_SCFA_RADIO_4_1, BST_UNCHECKED );

	CheckDlgButton( IDC_SCFA_RADIO_4_2, BST_UNCHECKED );

	//
	//
	CheckDlgButton( IDC_SCFB_RADIO_1_1, BST_CHECKED );

	CheckDlgButton( IDC_SCFB_RADIO_1_2, BST_CHECKED );

	CheckDlgButton( IDC_SCFB_RADIO_2_1, BST_CHECKED );

	CheckDlgButton( IDC_SCFB_RADIO_2_2_, BST_CHECKED );

	CheckDlgButton( IDC_SCFB_RADIO_3_1_, BST_CHECKED );

	CheckDlgButton( IDC_SCFB_RADIO_3_2_, BST_CHECKED );

	CheckDlgButton( IDC_SCFB_RADIO_4_1, BST_CHECKED );

	CheckDlgButton( IDC_SCFB_RADIO_4_2, BST_CHECKED );

	for ( ULONG i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ ) 
	{		
		if ( i == 0 ) 
		{			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != NULL ) 
			{
				m_btnRecordStart_1_1.EnableWindow( TRUE ); 

				m_btnRecordStop_1_1.EnableWindow( FALSE ); 

				m_btnRecordStart_1_2.EnableWindow( TRUE ); 

				m_btnRecordStop_1_2.EnableWindow( FALSE ); 
				
				m_checkGPU_1_1.EnableWindow( TRUE ); 

				m_checkGPU_1_1.SetCheck( 0 );

				m_checkGPU_1_2.EnableWindow( TRUE ); 

				m_checkGPU_1_2.SetCheck( 0 );
				
				GetDlgItem( IDC_SCFA_RADIO_1_1 )->EnableWindow( TRUE );

				GetDlgItem( IDC_SCFB_RADIO_1_1 )->EnableWindow( TRUE );

				GetDlgItem( IDC_SCFA_RADIO_1_2 )->EnableWindow( TRUE );

				GetDlgItem( IDC_SCFB_RADIO_1_2 )->EnableWindow( TRUE );
			}
			else 
			{
				m_btnRecordStart_1_1.EnableWindow( TRUE ); 

				m_btnRecordStop_1_1.EnableWindow( FALSE ); 

				m_btnRecordStart_1_2.EnableWindow( FALSE ); 

				m_btnRecordStop_1_2.EnableWindow( FALSE ); 
				
				m_checkGPU_1_1.EnableWindow( TRUE ); 

				m_checkGPU_1_1.SetCheck( 0 );

				m_checkGPU_1_2.EnableWindow( TRUE ); 

				m_checkGPU_1_2.SetCheck( 0 );

				GetDlgItem( IDC_SCFA_RADIO_1_1 )->EnableWindow( FALSE );

				GetDlgItem( IDC_SCFB_RADIO_1_1 )->EnableWindow( FALSE );

				GetDlgItem( IDC_SCFA_RADIO_1_2 )->EnableWindow( FALSE );

				GetDlgItem( IDC_SCFB_RADIO_1_2 )->EnableWindow( FALSE );
			}
		}

		if ( i == 1 ) 
		{			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != NULL ) 
			{
				m_btnRecordStart_2_1.EnableWindow( TRUE ); 

				m_btnRecordStop_2_1.EnableWindow( FALSE ); 

				m_btnRecordStart_2_2.EnableWindow( TRUE ); 

				m_btnRecordStop_2_2.EnableWindow( FALSE ); 
				
				m_checkGPU_2_1.EnableWindow( TRUE ); 

				m_checkGPU_2_1.SetCheck( 0 );

				m_checkGPU_2_2.EnableWindow( TRUE ); 

				m_checkGPU_2_2.SetCheck( 0 );
				
				GetDlgItem( IDC_SCFA_RADIO_2_1 )->EnableWindow( TRUE );

				GetDlgItem( IDC_SCFB_RADIO_2_1 )->EnableWindow( TRUE );

				GetDlgItem( IDC_SCFA_RADIO_2_2_ )->EnableWindow( TRUE );

				GetDlgItem( IDC_SCFB_RADIO_2_2_ )->EnableWindow( TRUE );
			}
			else 
			{			
				m_btnRecordStart_2_1.EnableWindow( FALSE ); 

				m_btnRecordStop_2_1.EnableWindow( FALSE ); 

				m_btnRecordStart_2_2.EnableWindow( FALSE ); 

				m_btnRecordStop_2_2.EnableWindow( FALSE ); 
				
				m_checkGPU_2_1.EnableWindow( TRUE ); 

				m_checkGPU_2_1.SetCheck( 0 );

				m_checkGPU_2_2.EnableWindow( TRUE ); 

				m_checkGPU_2_2.SetCheck( 0 );

				GetDlgItem( IDC_SCFA_RADIO_2_1 )->EnableWindow( FALSE );

				GetDlgItem( IDC_SCFB_RADIO_2_1 )->EnableWindow( FALSE );

				GetDlgItem( IDC_SCFA_RADIO_2_2_ )->EnableWindow( FALSE );

				GetDlgItem( IDC_SCFB_RADIO_2_2_ )->EnableWindow( FALSE );			
			}
		}

		if ( i == 2 ) 
		{			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != NULL ) 
			{
				m_btnRecordStart_3_1.EnableWindow( TRUE ); 

				m_btnRecordStop_3_1.EnableWindow( FALSE ); 

				m_btnRecordStart_3_2.EnableWindow( TRUE ); 

				m_btnRecordStop_3_2.EnableWindow( FALSE ); 
				
				m_checkGPU_3_1.EnableWindow( TRUE ); 

				m_checkGPU_3_1.SetCheck( 0 );

				m_checkGPU_3_2.EnableWindow( TRUE ); 

				m_checkGPU_3_2.SetCheck( 0 );
				
				GetDlgItem( IDC_SCFA_RADIO_3_1_ )->EnableWindow( TRUE );

				GetDlgItem( IDC_SCFB_RADIO_3_1_ )->EnableWindow( TRUE );

				GetDlgItem( IDC_SCFA_RADIO_3_2_ )->EnableWindow( TRUE );

				GetDlgItem( IDC_SCFB_RADIO_3_2_ )->EnableWindow( TRUE );
			}
			else 
			{			
				m_btnRecordStart_3_1.EnableWindow( FALSE ); 

				m_btnRecordStop_3_1.EnableWindow( FALSE ); 

				m_btnRecordStart_3_2.EnableWindow( FALSE ); 

				m_btnRecordStop_3_2.EnableWindow( FALSE ); 
				
				m_checkGPU_3_1.EnableWindow( TRUE ); 

				m_checkGPU_3_1.SetCheck( 0 );

				m_checkGPU_3_2.EnableWindow( TRUE ); 

				m_checkGPU_3_2.SetCheck( 0 );
				
				GetDlgItem( IDC_SCFA_RADIO_3_1_ )->EnableWindow( FALSE );

				GetDlgItem( IDC_SCFB_RADIO_3_1_ )->EnableWindow( FALSE );

				GetDlgItem( IDC_SCFA_RADIO_3_2_ )->EnableWindow( FALSE );

				GetDlgItem( IDC_SCFB_RADIO_3_2_ )->EnableWindow( FALSE );
			}
		}

		if ( i == 3 ) 
		{			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != NULL ) 
			{
				m_btnRecordStart_4_1.EnableWindow( TRUE ); 

				m_btnRecordStop_4_1.EnableWindow( FALSE ); 

				m_btnRecordStart_4_2.EnableWindow( TRUE ); 

				m_btnRecordStop_4_2.EnableWindow( FALSE ); 
				
				m_checkGPU_4_1.EnableWindow( TRUE ); 

				m_checkGPU_4_1.SetCheck( 0 );

				m_checkGPU_4_2.EnableWindow( TRUE ); 

				m_checkGPU_4_2.SetCheck( 0 );
				
				GetDlgItem( IDC_SCFA_RADIO_4_1 )->EnableWindow( TRUE );

				GetDlgItem( IDC_SCFB_RADIO_4_1 )->EnableWindow( TRUE );

				GetDlgItem( IDC_SCFA_RADIO_4_2 )->EnableWindow( TRUE );

				GetDlgItem( IDC_SCFB_RADIO_4_2 )->EnableWindow( TRUE );
			}
			else 
			{			
				m_btnRecordStart_4_1.EnableWindow( FALSE ); 

				m_btnRecordStop_4_1.EnableWindow( FALSE ); 

				m_btnRecordStart_4_2.EnableWindow( FALSE ); 

				m_btnRecordStop_4_2.EnableWindow( FALSE ); 
				
				m_checkGPU_4_1.EnableWindow( TRUE ); 

				m_checkGPU_4_1.SetCheck( 0 );

				m_checkGPU_4_2.EnableWindow( TRUE ); 

				m_checkGPU_4_2.SetCheck( 0 );
				
				GetDlgItem( IDC_SCFA_RADIO_4_1 )->EnableWindow( FALSE );

				GetDlgItem( IDC_SCFB_RADIO_4_1 )->EnableWindow( FALSE );

				GetDlgItem( IDC_SCFA_RADIO_4_2 )->EnableWindow( FALSE );

				GetDlgItem( IDC_SCFB_RADIO_4_2 )->EnableWindow( FALSE );
			}			
		}
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFileRecordDialog::OnDestroy() 
{
	OnButtonRecordStop11();
	OnButtonRecordStop12();
	OnButtonRecordStop21();
	OnButtonRecordStop22();
	OnButtonRecordStop31();
	OnButtonRecordStop32();
	OnButtonRecordStop41();
	OnButtonRecordStop42();

	CDialog::OnDestroy();
}

void CFileRecordDialog::OnButtonRecordStart11() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_1_1.EnableWindow( FALSE ); 

	m_btnRecordStop_1_1.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU1_1 = m_checkGPU_1_1.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 0 ] != 0 ) 
	{
		UINT iCheckedScfA, iCheckedScfB;

		iCheckedScfA = IsDlgButtonChecked( IDC_SCFA_RADIO_1_1 );

		iCheckedScfB = IsDlgButtonChecked( IDC_SCFB_RADIO_1_1 );

		if ( iCheckedScfA == BST_CHECKED ) 
		{			
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			m_strFullPath1 = m_pMainDialog->GetWorkingPath( "00_CH01M.SCF" );		
		}

        if ( iCheckedScfB == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			m_strFullPath1 = m_pMainDialog->GetWorkingPath( "00_CH01M.SCF" );			
		}

		ULONG nStrlen = m_strFullPath1.GetLength();

		CHAR * psz = m_strFullPath1.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU1_1 )
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
		}
		else
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
		}

		QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 0 ], 0, psz, QCAP_RECORD_FLAG_FULL, 0, 0, 3600 );

		m_pMainDialog->m_bIsRecord1_1 = TRUE;

		m_strFullPath1.ReleaseBuffer();
	}
}

void CFileRecordDialog::OnButtonRecordStart12() 
{
	// TODO: Add your control notification handler code here

 	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_1_2.EnableWindow( FALSE ); 

	m_btnRecordStop_1_2.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU1_2 = m_checkGPU_1_2.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 0 ] != NULL ) 
	{		
		UINT iCheckedScfA, iCheckedScfB;

		iCheckedScfA = IsDlgButtonChecked( IDC_SCFA_RADIO_1_2 );

		iCheckedScfB = IsDlgButtonChecked( IDC_SCFB_RADIO_1_2 );

		if ( iCheckedScfA == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			m_strFullPath2 = m_pMainDialog->GetWorkingPath( "01_CH01S.SCF" );
		}

        if ( iCheckedScfB == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			m_strFullPath2 = m_pMainDialog->GetWorkingPath( "01_CH01S.SCF" );			
		}

		ULONG nStrlen = m_strFullPath2.GetLength();

		CHAR* psz = m_strFullPath2.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU1_2 )
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
		}
		else
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 0 ], 1, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
		}

		QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 0 ], 1, psz, QCAP_RECORD_FLAG_FULL, 0, 0, 3600 );

		m_pMainDialog->m_bIsRecord1_2 = TRUE;

		m_strFullPath2.ReleaseBuffer();
	}
}

void CFileRecordDialog::OnButtonRecordStart21() 
{
	// TODO: Add your control notification handler code here

 	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_2_1.EnableWindow( FALSE ); 

	m_btnRecordStop_2_1.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU2_1 = m_checkGPU_2_1.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 1 ] != NULL ) 
	{
		UINT iCheckedScfA, iCheckedScfB;

		iCheckedScfA = IsDlgButtonChecked( IDC_SCFA_RADIO_2_1 );

		iCheckedScfB = IsDlgButtonChecked( IDC_SCFB_RADIO_2_1 );

		if ( iCheckedScfA == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			m_strFullPath3 = m_pMainDialog->GetWorkingPath( "02_CH02M.SCF" );			
		}

        if ( iCheckedScfB == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			m_strFullPath3 = m_pMainDialog->GetWorkingPath( "02_CH02M.SCF" );			
		}

		ULONG nStrlen = m_strFullPath3.GetLength();

		CHAR* psz = m_strFullPath3.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU2_1 )
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
		}
		else
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
		}

		QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 1 ], 0, psz, QCAP_RECORD_FLAG_FULL, 0, 0, 3600 );

		m_pMainDialog->m_bIsRecord2_1 = TRUE;

		m_strFullPath3.ReleaseBuffer();
	}	
}

void CFileRecordDialog::OnButtonRecordStart22() 
{
	// TODO: Add your control notification handler code here

 	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_2_2.EnableWindow( FALSE ); 

	m_btnRecordStop_2_2.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU2_2 = m_checkGPU_2_2.GetCheck();

	if (m_pMainDialog->m_hVideoDevice[ 1 ] != 0) 
	{
		UINT iCheckedScfA, iCheckedScfB;

		iCheckedScfA = IsDlgButtonChecked( IDC_SCFA_RADIO_2_2_ );

		iCheckedScfB = IsDlgButtonChecked( IDC_SCFB_RADIO_2_2_ );

		if ( iCheckedScfA == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			m_strFullPath4 = m_pMainDialog->GetWorkingPath( "03_CH02S.SCF" );
		}

        if ( iCheckedScfB == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			m_strFullPath4 = m_pMainDialog->GetWorkingPath( "03_CH02S.SCF" );
		}

		ULONG nStrlen = m_strFullPath4.GetLength();

		CHAR* psz = m_strFullPath4.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU2_2 )
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
		}
		else
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 1 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
		}

		QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 1 ], 1, psz, QCAP_RECORD_FLAG_FULL, 0, 0, 3600 );

		m_pMainDialog->m_bIsRecord2_2 = true;

		m_strFullPath4.ReleaseBuffer();
	}
}

void CFileRecordDialog::OnButtonRecordStart31() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();
	
	m_btnRecordStart_3_1.EnableWindow( FALSE ); 

	m_btnRecordStop_3_1.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU3_1 = m_checkGPU_3_1.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 2 ] != NULL ) 
	{
		UINT iCheckedSCFA, iCheckedSCFB;

		iCheckedSCFA = IsDlgButtonChecked( IDC_SCFA_RADIO_3_1_ );

		iCheckedSCFB = IsDlgButtonChecked( IDC_SCFB_RADIO_3_1_ );

		if ( iCheckedSCFA == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			m_strFullPath5 = m_pMainDialog->GetWorkingPath( "04_CH03M.SCF" );			
		}

        if ( iCheckedSCFB == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			m_strFullPath5 = m_pMainDialog->GetWorkingPath( "04_CH03M.SCF" );			
		}

		ULONG nStrlen = m_strFullPath5.GetLength();

		CHAR* psz = m_strFullPath5.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU3_1 )
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
		}
		else
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
		}

		QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 2 ], 0, psz, QCAP_RECORD_FLAG_FULL, 0, 0, 3600 );		

		m_pMainDialog->m_bIsRecord3_1 = TRUE;

		m_strFullPath5.ReleaseBuffer();
	}
}

void CFileRecordDialog::OnButtonRecordStart32() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_3_2.EnableWindow( FALSE ); 

	m_btnRecordStop_3_2.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU3_2 = m_checkGPU_3_2.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 2 ] != NULL ) 
	{
		UINT iCheckedSCFA, iCheckedSCFB;

		iCheckedSCFA = IsDlgButtonChecked( IDC_SCFA_RADIO_3_2_ );

		iCheckedSCFB = IsDlgButtonChecked( IDC_SCFB_RADIO_3_2_ );

		if ( iCheckedSCFA == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			m_strFullPath6 = m_pMainDialog->GetWorkingPath( "05_CH03S.SCF" );			
		}

        if ( iCheckedSCFB == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			m_strFullPath6 = m_pMainDialog->GetWorkingPath( "05_CH03S.SCF" );			
		}

		ULONG nStrlen = m_strFullPath6.GetLength();

		CHAR* psz = m_strFullPath6.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU3_2 )
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
		}
		else
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 2 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
		}

		QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 2 ], 1, psz, QCAP_RECORD_FLAG_FULL, 0, 0, 3600 );

		m_pMainDialog->m_bIsRecord3_2 = TRUE;

		m_strFullPath6.ReleaseBuffer();
	}	
}

void CFileRecordDialog::OnButtonRecordStart41() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_4_1.EnableWindow( FALSE ); 

	m_btnRecordStop_4_1.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU4_1 = m_checkGPU_4_1.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 3 ] != NULL ) 
	{
		UINT iCheckedSCFA, iCheckedSCFB;

		iCheckedSCFA = IsDlgButtonChecked( IDC_SCFA_RADIO_4_1 );

		iCheckedSCFB = IsDlgButtonChecked( IDC_SCFB_RADIO_4_1 );

		if ( iCheckedSCFA == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			m_strFullPath7 = m_pMainDialog->GetWorkingPath( "06_CH04M.SCF" );			
		}

        if ( iCheckedSCFB == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			m_strFullPath7 = m_pMainDialog->GetWorkingPath( "06_CH04M.SCF" );			
		}

		ULONG nStrlen = m_strFullPath7.GetLength();

		CHAR* psz = m_strFullPath7.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU4_1 )
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
		}
		else
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );
		}

		QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 3 ], 0, psz, QCAP_RECORD_FLAG_FULL, 0, 0, 3600 );		

		m_pMainDialog->m_bIsRecord4_1 = TRUE;

		m_strFullPath7.ReleaseBuffer();
	}		
}

void CFileRecordDialog::OnButtonRecordStart42() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_4_2.EnableWindow( FALSE ); 

	m_btnRecordStop_4_2.EnableWindow( TRUE ); 

	m_pMainDialog->m_bSupportGPU4_2 = m_checkGPU_4_2.GetCheck();

	if ( m_pMainDialog->m_hVideoDevice[ 3 ] != NULL ) 
	{
		UINT iCheckedSCFA, iCheckedSCFB;

		iCheckedSCFA = IsDlgButtonChecked( IDC_SCFA_RADIO_4_2 );

		iCheckedSCFB = IsDlgButtonChecked( IDC_SCFB_RADIO_4_2 );

		if ( iCheckedSCFA == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			m_strFullPath8 = m_pMainDialog->GetWorkingPath( "07_CH04S.SCF" );
		}

        if ( iCheckedSCFB == BST_CHECKED ) 
		{
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			m_strFullPath8 = m_pMainDialog->GetWorkingPath( "07_CH04S.SCF" );			
		}

		ULONG nStrlen = m_strFullPath8.GetLength();

		CHAR* psz = m_strFullPath8.GetBuffer( nStrlen+1 );

		if ( m_pMainDialog->m_bSupportGPU4_2 )
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
		}
		else
		{
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_pMainDialog->m_hVideoDevice[ 3 ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );
		}

		QCAP_START_RECORD( m_pMainDialog->m_hVideoDevice[ 3 ], 1, psz, QCAP_RECORD_FLAG_FULL, 0, 0, 3600 );

		m_pMainDialog->m_bIsRecord4_2 = TRUE;

		m_strFullPath8.ReleaseBuffer();
	}	
}

void CFileRecordDialog::OnButtonRecordStop11() 
{
	// TODO: Add your control notification handler code here

 	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_1_1.EnableWindow( TRUE ); 

	m_btnRecordStop_1_1.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 0 ] != NULL ) 
	{
		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 0 ], 0, TRUE, 0 );

		m_pMainDialog->m_bIsRecord1_1 = FALSE;
	}
}

void CFileRecordDialog::OnButtonRecordStop12() 
{
	// TODO: Add your control notification handler code here

 	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_1_2.EnableWindow( TRUE );

	m_btnRecordStop_1_2.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 0 ] != NULL ) 
	{
		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 0 ], 1 );

		m_pMainDialog->m_bIsRecord1_2 = FALSE;
	}	
}

void CFileRecordDialog::OnButtonRecordStop21() 
{
	// TODO: Add your control notification handler code here

 	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_2_1.EnableWindow( TRUE ); 

	m_btnRecordStop_2_1.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 1 ] != NULL ) 
	{
		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 1 ], 0 );

		m_pMainDialog->m_bIsRecord2_1 = FALSE;
	}	
}

void CFileRecordDialog::OnScfARadio11() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();			

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }		
}

void CFileRecordDialog::OnScfBRadio11() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();			

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnScfARadio12() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();		

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnScfBRadio12() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();		

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }		
}

void CFileRecordDialog::OnScfARadio21() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();		

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }		
}

void CFileRecordDialog::OnScfBRadio21() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();	

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }		
}

void CFileRecordDialog::OnScfARadio22() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();		

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnScfBRadio22() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();		

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnScfARadio31() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();		

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }		
}

void CFileRecordDialog::OnScfBRadio31() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();		

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnScfARadio32() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();		

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }		
}

void CFileRecordDialog::OnScfBRadio32() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();		

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }		
}

void CFileRecordDialog::OnScfARadio41() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();	

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnScfBRadio41() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }		
}

void CFileRecordDialog::OnScfARadio42() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();	

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }		
}

void CFileRecordDialog::OnScfBRadio422() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();		

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1, iCheckedSCFA_1_2, iCheckedSCFB_1_2;
	
	UINT iCheckedSCFA_2_1, iCheckedSCFB_2_1, iCheckedSCFA_2_2, iCheckedSCFB_2_2;

	UINT iCheckedSCFA3_1, iCheckedSCFB_3_1, iCheckedSCFA3_2, iCheckedSCFB_3_2;
	
	UINT iCheckedSCFA_4_1, iCheckedSCFB_4_1, iCheckedSCFA_4_2, iCheckedSCFB_4_2;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->GetCheck();

	iCheckedSCFA_1_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->GetCheck();

	iCheckedSCFB_1_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->GetCheck();

	iCheckedSCFA_2_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->GetCheck();

	iCheckedSCFB_2_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->GetCheck();
	
	iCheckedSCFA_2_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->GetCheck();		// 1 PRESENT BE CHOSEN, 0 BE ELSE

	iCheckedSCFB_2_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->GetCheck();

	iCheckedSCFA3_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->GetCheck();		

	iCheckedSCFB_3_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->GetCheck();

	iCheckedSCFA3_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->GetCheck();
	
	iCheckedSCFB_3_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->GetCheck();

	iCheckedSCFA_4_1 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->GetCheck();		

	iCheckedSCFB_4_1 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->GetCheck();

	iCheckedSCFA_4_2 = ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->GetCheck();
	
	iCheckedSCFB_4_2 = ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2 ))->GetCheck();

	if ( iCheckedSCFA_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_1_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_1 ))->SetCheck( TRUE ); }	

	if ( iCheckedSCFA_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_2_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_2_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_1_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA3_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_3_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_3_2_ ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_1 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_1 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFA_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFA_RADIO_4_2 ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_4_2 ){ ((CButton*)GetDlgItem( IDC_SCFB_RADIO_4_2))->SetCheck( TRUE ); }	
}

void CFileRecordDialog::OnButtonRecordStop22() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_2_2.EnableWindow( TRUE );

	m_btnRecordStop_2_2.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 1 ] != NULL ) 
	{
		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 1 ], 1 );

		m_pMainDialog->m_bIsRecord2_2 = FALSE;
	}	
}

void CFileRecordDialog::OnButtonRecordStop31() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_3_1.EnableWindow( TRUE ); 

	m_btnRecordStop_3_1.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 2 ] != NULL ) 
	{
		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 2 ], 0 );

		m_pMainDialog->m_bIsRecord3_1 = FALSE;
	}	
}

void CFileRecordDialog::OnButtonRecordStop32() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_3_2.EnableWindow( TRUE );

	m_btnRecordStop_3_2.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 2 ] != NULL ) 
	{
		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 2 ], 1 );

		m_pMainDialog->m_bIsRecord3_2 = FALSE;
	}	
}

void CFileRecordDialog::OnButtonRecordStop41() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_4_1.EnableWindow( TRUE ); 

	m_btnRecordStop_4_1.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 3 ] != NULL ) 
	{
		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 3 ], 0 );

		m_pMainDialog->m_bIsRecord4_1 = FALSE;
	}	
}

void CFileRecordDialog::OnButtonRecordStop42() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnRecordStart_4_2.EnableWindow( TRUE );

	m_btnRecordStop_4_2.EnableWindow( FALSE ); 

	if ( m_pMainDialog->m_hVideoDevice[ 3 ] != NULL ) 
	{
		QCAP_STOP_RECORD( m_pMainDialog->m_hVideoDevice[ 3 ], 1 );

		m_pMainDialog->m_bIsRecord4_2 = FALSE;
	}
}
