// MyRecordAV.cpp: implementation of the MyRecordAV class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Security_Demo.h"
#include "MyRecordAV.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

SYSTEMTIME g_stStartRecTime[ 32 ];

SYSTEMTIME g_stEndRecTime[ 32 ];

double g_dRecFrameRate[ 32 ] = { 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000 };

ULONG  g_nRecVideoFrameNumber[ 32 ] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

UINT  g_RecTimerHandle[ 32  ] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

extern CString g_strRecordFrameRate[ 32 ];

typedef VOID (*TFCALLBACK2)( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime );

VOID RecTimerProc( ULONG nCHID, HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime )
{
	ULONG i = nCHID - 1;

	CTimeSpan timeSpan;

	CTime timeCurrent = CTime::GetCurrentTime();

	CTime timeStart( g_stStartRecTime[ i ] );

	timeSpan = timeCurrent - timeStart;

	LONGLONG nSeconds = 0;

	nSeconds = timeSpan.GetTotalSeconds();

	if (nSeconds == 0) nSeconds = 1;

	g_dRecFrameRate[ i ] = (double)g_nRecVideoFrameNumber[ i ] / (double)nSeconds;

	g_strRecordFrameRate[ i ].Format( "%.3f", g_dRecFrameRate[ i ] );
}

VOID RecTimerProc1( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 1, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 2, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc3( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 3, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc4( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 4, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc5( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 5, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc6( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 6, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc7( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 7, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc8( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 8, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc9( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 9, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc10( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 10, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc11( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 11, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc12( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 12, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc13( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 13, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc14( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 14, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc15( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 15, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc16( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 16, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc17( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 17, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc18( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 18, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc19( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 19, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc20( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 20, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc21( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 21, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc22( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 22, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc23( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 23, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc24( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 24, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc25( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 25, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc26( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 26, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc27( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 27, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc28( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 28, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc29( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 29, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc30( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 30, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc31( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 31, hWnd, nMsg, nIdEvent, dwTime ); }
VOID RecTimerProc32( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { RecTimerProc( 32, hWnd, nMsg, nIdEvent, dwTime ); }

TFCALLBACK2 g_RecTimerProc[ 32 ] = 
{  
	RecTimerProc1, RecTimerProc2, RecTimerProc3, RecTimerProc4, RecTimerProc5, RecTimerProc6, RecTimerProc7, RecTimerProc8, RecTimerProc9, RecTimerProc10, RecTimerProc11, RecTimerProc12, RecTimerProc13, RecTimerProc14, RecTimerProc15, RecTimerProc16, RecTimerProc17, RecTimerProc18, RecTimerProc19, RecTimerProc20, RecTimerProc21, RecTimerProc22, RecTimerProc23, RecTimerProc24, RecTimerProc25, RecTimerProc26, RecTimerProc27, RecTimerProc28, RecTimerProc29, RecTimerProc30, RecTimerProc31, RecTimerProc32
};

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MyRecordAV::MyRecordAV()
{
	m_nChannelID					= 0;

	m_nVideoFrameNumber				= 0;

	m_nAudioFrameNumber				= 0;

	m_dFrameRate					= 29.97;

	m_bIsRecording					= FALSE;

	m_bConnect						= FALSE;

	m_bIsRecording					= FALSE;

	m_nColorSpaceType				= MAKEFOURCC('H', '2', '6', '4');

	m_nCameraType					= 0x00000001;

	m_nFrameWidth					= 352; 
	
	m_nFrameHeight					= 240;

	m_nBitCount						= 24;;

	m_hFileRendererDev				= 0xFFFFFFFF;		

	m_nFileRendererRecordState      = 0x00000000;

	m_bFileRendererChangeNotify     = FALSE;
}

MyRecordAV::~MyRecordAV()
{
	Disconnect();
}

BOOL MyRecordAV::Connect()
{
	if (m_nChannelID == 0) { return FALSE; }

	if (IsConnected() == TRUE) { return TRUE; }		

	g_RecTimerHandle[ m_nChannelID - 1 ] = 0;

	g_nRecVideoFrameNumber[ m_nChannelID - 1 ]  = 0;

	// CREATE A FILE RENDERER TO DO FILE RECORDING
	//
	m_hFileRendererDev = AMESDK_CREATE( m_strFileRendererChangeDevName.GetBuffer( MAX_PATH ), (m_nChannelID - 1), 3, NULL, NULL, NULL );

	m_strFileRendererChangeDevName.ReleaseBuffer();
	
	if( m_hFileRendererDev & 0x80000000 ) 
	{ 
		m_hFileRendererDev = 0xFFFFFFFF;

		return FALSE;	
	}

	m_nFileRendererRecordState = 0x00000000; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME	

	m_bIsRecording = FALSE;

	m_nVideoFrameNumber = 0;

	m_nAudioFrameNumber	= 0;
	
	m_bConnect = TRUE;	

	return m_bConnect;
}

BOOL MyRecordAV::Disconnect()
{
    if (IsConnected() == FALSE)  {  return FALSE;  }

	g_RecTimerHandle[ m_nChannelID - 1 ] = 0;

	g_nRecVideoFrameNumber[ m_nChannelID - 1 ]  = 0;

	BOOL bDisConnect = FALSE;

	m_strFileRendererChangeDevName.Empty();

	SetRecordStop();	

	m_bConnect = FALSE;	

	return bDisConnect;
}

BOOL MyRecordAV::SetFilePathName( CHAR * szFileRendererName )
{	
	if ( m_bIsRecording ) { return FALSE; }		

	SYSTEMTIME system_times; GetLocalTime( &system_times );

	m_sFileRendererChangeSystemTime = system_times;

	m_strFileRendererChangeDevName.Empty();

	m_strFileRendererChangeDevName.Format( "Common Analog File Renderer %s", szFileRendererName );		

	return TRUE;
}

BOOL MyRecordAV::SetRecordFormat( ULONG nColorSpaceType, ULONG nWidth, ULONG nHeight, ULONG nBitCount, double dFrameRate )
{
	if ( m_bIsRecording == TRUE )  { return FALSE; }

	m_nColorSpaceType = MAKEFOURCC('H', '2', '6', '4');

	m_nFrameWidth = nWidth;

	m_nFrameHeight = nHeight;

	m_nBitCount = nBitCount;

	m_dFrameRate = dFrameRate;	

	return TRUE;
}

BOOL MyRecordAV::SetRecordRun()
{	
	if ( m_bIsRecording == TRUE )  { return FALSE; }

	if ( m_strFileRendererChangeDevName.IsEmpty() ) { return FALSE; }	

	if ( Connect() == FALSE ) { return FALSE; }

	m_nColorSpaceType = MAKEFOURCC('H', '2', '6', '4');	

	BOOL bSet = FALSE;			

	if ( m_nFrameHeight > 288 )
		bSet = AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( m_hFileRendererDev, m_nColorSpaceType, m_nFrameWidth, m_nFrameHeight, m_nBitCount, m_dFrameRate, AMESDK_FILE_CUSTOMFLAG_ISSYNCHRONIZATION | AMESDK_FILE_CUSTOMFLAG_ISINTERLEAVED );
	else
		bSet = AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( m_hFileRendererDev, m_nColorSpaceType, m_nFrameWidth, m_nFrameHeight, m_nBitCount, m_dFrameRate, AMESDK_FILE_CUSTOMFLAG_ISSYNCHRONIZATION );

	if ( bSet == FALSE ) { return FALSE; }

	AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hFileRendererDev, 2, 16, 16000 ); // STEREO / 16BITS / 16000HZ 	

	m_nFileRendererRecordState = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME
	
	m_bIsRecording = TRUE;

	g_nRecVideoFrameNumber[ m_nChannelID - 1 ]  = 0;

	GetLocalTime( &g_stStartRecTime[ m_nChannelID - 1  ] );

	g_RecTimerHandle[ m_nChannelID - 1 ] = ::SetTimer( NULL, 0x00000002, 1000, (TIMERPROC) g_RecTimerProc[ m_nChannelID - 1 ] );

	return TRUE;
}

BOOL MyRecordAV::SetRecordStop()
{
	m_nFileRendererRecordState = 0x00000000;

	g_nRecVideoFrameNumber[ m_nChannelID - 1 ]  = 0;

	::KillTimer( NULL, g_RecTimerHandle[ m_nChannelID - 1 ] );

	g_RecTimerHandle[ m_nChannelID - 1 ] = 0;	

	g_strRecordFrameRate[ m_nChannelID - 1 ] = "0.000";

	if( m_hFileRendererDev != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileRendererDev ); m_hFileRendererDev = 0xFFFFFFFF; }	

	m_nVideoFrameNumber = 0;

	m_nAudioFrameNumber	= 0;	

	m_bIsRecording = FALSE;	

	m_bConnect = FALSE;	

	return TRUE;
}